package com.zjty.tynotes.job.basic.service;

import com.zjty.tynotes.job.basic.entity.database.Comment;
import com.zjty.tynotes.job.basic.service.impl.CommentServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 14:43
 * <p>@author : C
 * 实现类见↓
 *
 * @see CommentServiceImpl
 */
@Service
public interface CommentService {

    /**
     * 新增Comment
     * 不可附带id
     *
     * @param comment Comment对象
     * @return 新增对象的id
     */
    String add(Comment comment);

    /**
     * 根据workId新增Comment并与所属Work建立关系
     * 不可附带id
     *
     * @param comment Comment对象
     * @param workId  所属工作Id
     * @return Comment对象的id
     */
    String add(Comment comment, String workId);

    /**
     * 修改Comment
     * 必须附带id
     *
     * @param comment Comment对象
     * @return 更新对象的id
     */
    String modify(Comment comment);

    /**
     * 查询所有
     *
     * @return 对象集合
     */
    List<Comment> findAll();

    /**
     * 根据id集合查询所有
     *
     * @param ids id集合
     * @return 对象集合
     */
    List<Comment> findAll(List<String> ids);

    /**
     * 根据id删除
     *
     * @param id 指定id
     */
    void delete(String id);

    /**
     * 删除所有数据
     */
    void deleteAll();
}
