package com.zjty.tynotes.job.basic.service;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.service.impl.WorkServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 9:54
 * <p>@author : C
 * 实现类见↓
 *
 * @see WorkServiceImpl
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Service
public interface WorkService {

    /**
     * 新增工作
     * 不可附带id
     *
     * @param work Work对象
     * @return 新增对象的id
     */
    String add(Work work);

    /**
     * 修改工作
     * 必须附带id
     *
     * @param work Work对象
     * @return 更新对象的id
     */
    String modify(Work work);

    /**
     * 指定id的Work是否存在
     *
     * @param workId 指定id
     * @return 是否存在
     */
    Boolean idExists(String workId);

    /**
     * 查询所有工作
     *
     * @return 对象集合
     */
    List<Work> findAll();

    /**
     * 根据id集合查询所有
     *
     * @param ids id集合
     * @return 对象集合
     */
    List<Work> findAll(List<String> ids);

    /**
     * 查找指定id的Work
     *
     * @param workId 指定id
     * @return Work对象
     */
    Work findById(String workId);

    /**
     * 根据id删除
     *
     * @param id 指定id
     */
    void delete(String id);

    /**
     * 删除所有数据
     */
    void deleteAll();

//    /**
//     * 查看正在进行中的任务
//     */
//    List<Work> selectTimeWork();
}
