package com.zjty.tynotes.job.basic.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Attachment;
import com.zjty.tynotes.job.basic.entity.database.Comment;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.entity.response.CommentVo;
import com.zjty.tynotes.job.basic.entity.response.WorkVo;
import com.zjty.tynotes.job.basic.service.AttachmentService;
import com.zjty.tynotes.job.basic.service.CommentService;
import com.zjty.tynotes.job.basic.service.TransHelper;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.service.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Description : note
 * <p>Date : 2019/4/24 17:05
 * <p>@author : C
 */
@Service
@Slf4j
public class TransHelperImpl implements TransHelper {

    private final
    IUserService userService;

    private final
    AttachmentService attachmentService;

    private final
    CommentService commentService;

    @Autowired
    public TransHelperImpl(IUserService userService, AttachmentService attachmentService, CommentService commentService) {
        this.userService = userService;
        this.attachmentService = attachmentService;
        this.commentService = commentService;
    }

    @Override
    public WorkVo transToVo(Work work) {
        User publisher = userService.findUserById(work.getPublisher());
        User executor = userService.findUserById(work.getExecutor());
        List<User> checkerList = userService.findUserByIds(work.getChecker());
        List<User> followerList = userService.findUserByIds(work.getFollower());
        List<Attachment> attachmentList = attachmentService.findAll(work.getAttachment());
        List<Comment> commentList = commentService.findAll(work.getComment());
        List<CommentVo> commentVoList = commentList.stream().map(this::toCommentVo).collect(Collectors.toList());
        return new WorkVo(
                work.getId(),
                work.getTitle(),
                work.getCreateTime(),
                work.getCompleteTime(),
                work.getUpdateTime(),
                publisher,
                executor,
                checkerList,
                followerList,
                attachmentList,
                commentVoList,
                work.getContent(),
                work.getIsFormal(),
                work.getStatus()
        );
    }

    @Override
    public Work transToDataBase(WorkVo workVo) {
        return new Work(
                workVo.getId(),
                workVo.getTitle(),
                workVo.getCreateTime(),
                workVo.getCompleteTime(),
                workVo.getUpdateTime(),
                workVo.getPublisher().getId(),
                workVo.getExecutor().getId(),
                getUserIds(workVo.getChecker()),
                getUserIds(workVo.getFollower()),
                getAttachmentIds(workVo.getAttachment()),
                getCommentIds(workVo.getComment()),
                workVo.getContent(),
                workVo.getIsFormal(),
                workVo.getStatus()
        );
    }

    private List<String> getUserIds(List<User> userList) {
        return userList.stream()
                .map(User::getId)
                .collect(Collectors.toList());
    }

    private List<String> getAttachmentIds(List<Attachment> attachmentList) {
        return attachmentList.stream()
                .map(Attachment::getId)
                .collect(Collectors.toList());
    }

    private List<String> getCommentIds(List<CommentVo> commentVoList) {
        return commentVoList.stream()
                .map(CommentVo::getId)
                .collect(Collectors.toList());
    }


    private CommentVo toCommentVo(Comment comment) {
        return new CommentVo(
                comment.getId(),
                userService.findUserById(comment.getCommentator()),
                comment.getCreateTime(),
                comment.getUpdateTime(),
                comment.getContent()
        );
    }
}
