package com.zjty.tynotes.job.basic.service.impl;

import com.google.common.collect.Lists;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.repository.WorkRepository;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.common.exception.BadRequestException;
import com.zjty.tynotes.job.common.exception.NotFoundException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Optional;

import static java.util.Objects.isNull;
import static java.util.Objects.nonNull;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 11:32
 * <p>@author : C
 * 接口定义说明见↓
 *
 * @see WorkService
 */
@Slf4j
@Service
public class WorkServiceImpl implements WorkService {

    private final
    WorkRepository workRepository;

    @Autowired
    public WorkServiceImpl(WorkRepository workRepository) {
        this.workRepository = workRepository;
    }

    @Override
    public String add(Work work) {
        //新增数据不可附带id.
        Boolean idMustNull = isNull(work.getId());
        if (idMustNull) {
            work.setCreateTime(new Date());
            work.setUpdateTime(new Date());
            String saveId = workRepository.save(work).getId();
            log.info(String.format("[job]  新增了id为 %s 的数据.", saveId));
            return saveId;
        } else {
            String msg = "[job] %s: 新增数据不可附带id.";
            log.error(msg);
            throw new BadRequestException(msg);
        }
    }

    @Override
    public String modify(Work work) {
        //更新数据必须指定id且指定id的数据存在.
        Boolean idMustExist = (nonNull(work.getId())) && (workRepository.existsById(work.getId()));
        if (idMustExist) {
            String modifyId = workRepository.save(work).getId();
            log.info(String.format("[job] 更新了id为 %s 的数据.", modifyId));
            return modifyId;
        } else {
            String msg = "[job] 更新数据必须指定id且指定id的数据存在.";
            log.error(msg);
            throw new BadRequestException(msg);
        }
    }

    @Override
    public List<Work> findAll() {
        return workRepository.findAll();
    }

    @Override
    public List<Work> findAll(List<String> ids) {
        return Lists.newArrayList(workRepository.findAllById(ids));
    }

    @Override
    public Boolean idExists(String workId) {
        return workRepository.existsById(workId);
    }

    @Override
    public Work findById(String workId) {
        Optional<Work> workOptional = workRepository.findById(workId);
        return workOptional.orElseThrow(() -> new BadRequestException(String.format("[job] id为 %s 的数据不存在.", workId)));
    }

    @Override
    public void delete(String workId) {
        if (workRepository.existsById(workId)) {
            workRepository.deleteById(workId);
        } else {
            throw new NotFoundException(String.format("[job] id为 %s 的工作不存在.", workId));
        }
    }

    @Override
    public void deleteAll() {
    }

//    @Override
//    public List<Work> selectTimeWork() {
////        LocalDateTime minTime = LocalDateTime.now().with(LocalTime.MIN).atZone(ZoneOffset.ofHours(8)).ge;
//        workRepository.findByCompleteTimeGreaterThan(new Date());
//        return null;
//    }
}
