package com.zjty.tynotes.job.business.service;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.business.service.impl.NoteMessageServiceImpl;
import com.zjty.tynotes.job.common.Action;
import org.springframework.stereotype.Service;

/**
 * <p>Description : ty-note-backend
 * <p>Date : 2019/5/13 10:25
 * <p>@author : C
 * 接口实现见
 *
 * @see NoteMessageServiceImpl
 */
@Service
public interface NoteMessageService {

    /**
     * 发生使工作变化的相关操作时（新增、修改）
     * 需要记录下来
     * 保存操作记录（已知操作编号的情况下）
     *
     * @param userId  执行该次操作的用户的id
     * @param workId  该次操作涉及的工作的id
     * @param action  操作编号
     * @param remarks 备注内容
     *                操作编号详细见↓
     * @see Action
     */
    void saveNoteMessage(String userId, String workId, Integer action, String remarks);

    /**
     * 同上
     * 保存操作记录（未知操作编号的情况下）
     * (先对比新旧Work对象 判断出操作编号 再保存)
     *
     * @param userId  执行该次操作的用户的id
     * @param workId  该次操作涉及的工作的id
     * @param newWork 操作后的Work对象
     * @param oldWork 原Work对象
     * @param remarks 备注内容
     *                操作编号详细见↓
     * @see Action
     */
    void saveNoteMessage(String userId, String workId, Work newWork, Work oldWork, String remarks);

}
