package com.zjty.tynotes.job.business.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.entity.request.UserRo;
import com.zjty.tynotes.job.basic.repository.WorkRepository;
import com.zjty.tynotes.job.business.service.AlterTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import javax.management.Query;
import java.util.Optional;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-22
 */
@Service
public class AlterTaskStatusImpl implements AlterTaskService {

    @Autowired
    private WorkRepository workRepository;

    @Override
    public void alterTaskStatus(String taskId, String status) {

        Work ob = workRepository.findById(taskId).get();

        ob.setStatus(status);

        workRepository.save(ob);
    }

    @Override
    public void updateFlower(UserRo userRo) {
        Work ob = workRepository.findById(userRo.getWorkId()).get();

        ob.setFollower(userRo.getUsers());

        workRepository.save(ob);
    }

    @Override
    public void updateChecker(UserRo userRo) {
        Work ob = workRepository.findById(userRo.getWorkId()).get();

        ob.setChecker(userRo.getUsers());

        workRepository.save(ob);
    }

}
