package com.zjty.tynotes.job.business.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.business.service.NoteMessageService;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.status.service.BusinessTreeManagement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

import static com.zjty.tynotes.job.common.Action.*;
import static com.zjty.tynotes.job.common.constant.WorkStatus.COMMITTED;
import static com.zjty.tynotes.job.common.constant.WorkStatus.FINISHED;
import static com.zjty.tynotes.job.common.constant.WorkStatus.UNDERWAY;

/**
 * <p>Description : ty-note-backend
 * <p>Date : 2019/5/13 13:37
 * <p>@author : C
 * 接口定义见
 *
 * @see NoteMessageService
 */
@Service
public class NoteMessageServiceImpl implements NoteMessageService {

    private final
    BusinessTreeManagement businessTreeManagement;

    @Autowired
    public NoteMessageServiceImpl(BusinessTreeManagement businessTreeManagement) {
        this.businessTreeManagement = businessTreeManagement;
    }

    @Override
    public void saveNoteMessage(String userId, String workId, Integer action, String remarks) {
        Boolean remarksRequired = action.equals(COMMIT_WORK) || action.equals(BACK_WORK) || action.equals(FINISH_WORK);
        Boolean remarksExist = Objects.nonNull(remarks);
        if (remarksRequired && remarksExist) {
            businessTreeManagement.saveAction(userId, workId, action, new Date(), remarks);
        } else {
            businessTreeManagement.saveAction(userId, workId, action, new Date(), "");
        }
    }

    @Override
    public void saveNoteMessage(String userId, String workId, Work newWork, Work oldWork, String remarks) {
        Integer action = 0;
        Boolean publishWork = Objects.equals(oldWork.getIsFormal(), false) && Objects.equals(newWork.getIsFormal(), true);
        Boolean commitWork = Objects.equals(oldWork.getStatus(), UNDERWAY) && Objects.equals(newWork.getStatus(), WorkStatus.COMMITTED);
        Boolean backWork = Objects.equals(oldWork.getStatus(), COMMITTED) && Objects.equals(newWork.getStatus(), UNDERWAY);
        Boolean finishWork = Objects.equals(oldWork.getStatus(), COMMITTED) && Objects.equals(newWork.getStatus(), FINISHED);
        Boolean alterChecker = !Objects.equals(oldWork.getChecker(), newWork.getChecker());
        Boolean alterFollower = !Objects.equals(oldWork.getFollower(), newWork.getFollower());
        Boolean comment = !Objects.equals(oldWork.getComment(), newWork.getComment());
        if (publishWork) {
            action = PUBLISH_WORK;
        } else if (commitWork) {
            action = COMMIT_WORK;
        } else if (backWork) {
            action = BACK_WORK;
        } else if (finishWork) {
            action = FINISH_WORK;
        } else if (alterChecker) {
            action = ALTER_CHECKER;
        } else if (alterFollower) {
            action = ALTER_FOLLOWER;
        } else if (comment) {
            action = COMMENT;
        }
        saveNoteMessage(userId, workId, action, remarks);
    }

}
