package com.zjty.tynotes.job.status.controller;

import com.zjty.tynotes.job.status.entity.BouncedMessage;
import com.zjty.tynotes.job.status.entity.EsListSum;
import com.zjty.tynotes.job.status.entity.EventTitle;
import com.zjty.tynotes.job.status.service.EventService;
import com.zjty.tynotes.job.status.service.PrivateService;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

/**
 * @author zjm
 */
@AutoDocument
@RestController
@RequestMapping("/read")
@Api(tags = "阅读页面接口", value = "阅读页面数据")
public class ReadController {
    @Autowired
    EventService eventService;
    @Autowired
    PrivateService privateService;
    /**
     *阅读页面待审核列表
     * @param page              页码 默认1
     * @param size              每页显示条数 默认10
     * @param id                人员id
     */
    @PostMapping("/selectCommission")
    @ApiOperation(value = "获取阅读页面待审核列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query",required = true),
            @ApiImplicitParam(name="page",value="页码",dataType="int", paramType = "query",example = "1"),
            @ApiImplicitParam(name="size",value="每页显示条数",dataType="int", paramType = "query",example = "10")
    })
    public ResponseEntity<EsListSum> selectCommission(@RequestParam(value = "id") String id,
                                                             @RequestParam(value = "page", defaultValue = "1") int page,
                                                             @RequestParam(value = "size", defaultValue = "10") int size){

        int pageSize;
        if (page==0){
            pageSize=0;
        }else {
            pageSize=page-1;
        }

        return ResponseEntity.ok(privateService.selectCommission(id,pageSize,size));
    }

    /**
     *阅读页面已提交列表
     * @param page              页码 默认1
     * @param size              每页显示条数 默认10
     * @param id                人员id
     */
    @PostMapping("/selectSubmit")
    @ApiOperation(value = "获取阅读页面已提交列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query",required = true),
            @ApiImplicitParam(name="page",value="页码",dataType="int", paramType = "query",example = "1"),
            @ApiImplicitParam(name="size",value="每页显示条数",dataType="int", paramType = "query",example = "10")
    })
    public ResponseEntity<EsListSum> selectSubmit(@RequestParam(value = "id") String id,
                                                @RequestParam(value = "page", defaultValue = "1") int page,
                                                @RequestParam(value = "size", defaultValue = "10") int size){

        int pageSize;
        if (page==0){
            pageSize=0;
        }else {
            pageSize=page-1;
        }

        return ResponseEntity.ok(privateService.selectSubmit(id,pageSize,size));
    }

    /**
     *阅读页面其他列表
     * @param page              页码 默认1
     * @param size              每页显示条数 默认10
     * @param id                人员id
     */
    @PostMapping("/selectOther")
    @ApiOperation(value = "获取阅读页面其他列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query",required = true),
            @ApiImplicitParam(name="page",value="页码",dataType="int", paramType = "query",example = "1"),
            @ApiImplicitParam(name="size",value="每页显示条数",dataType="int", paramType = "query",example = "10")
    })
    public ResponseEntity<EsListSum> selectOther(@RequestParam(value = "id") String id,
                                                @RequestParam(value = "page", defaultValue = "1") int page,
                                                @RequestParam(value = "size", defaultValue = "10") int size){

        int pageSize;
        if (page==0){
            pageSize=0;
        }else {
            pageSize=page-1;
        }
        return ResponseEntity.ok(privateService.selectOther(id,pageSize,size));
    }

    /**
     *阅读页面收藏列表
     * @param page              页码 默认1
     * @param size              每页显示条数 默认10
     * @param id                人员id
     */
    @PostMapping("/selectCollection")
    @ApiOperation(value = "获取阅读页面收藏列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query",required = true),
            @ApiImplicitParam(name="page",value="页码",dataType="int", paramType = "query",example = "1"),
            @ApiImplicitParam(name="size",value="每页显示条数",dataType="int", paramType = "query",example = "10")
    })
    public ResponseEntity<EsListSum> selectCollection(@RequestParam(value = "id") String id,
                                                      @RequestParam(value = "page", defaultValue = "1") int page,
                                                      @RequestParam(value = "size", defaultValue = "10") int size){

        int pageSize;
        if (page==0){
            pageSize=0;
        }else {
            pageSize=page-1;
        }
        return ResponseEntity.ok(privateService.selectCollection(id,pageSize,size));
    }

    /**
     *阅读页面标题查询列表
     * @param page              页码 默认1
     * @param size              每页显示条数 默认10
     * @param id                人员id
     */
    @PostMapping("/titleSelect")
    @ApiOperation(value = "获取阅读页面标题查询列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query",required = true),
            @ApiImplicitParam(name="page",value="页码",dataType="int", paramType = "query",example = "1"),
            @ApiImplicitParam(name="size",value="每页显示条数",dataType="int", paramType = "query",example = "10"),
            @ApiImplicitParam(name="title",value="标题",dataType="string", paramType = "query")
    })
    public ResponseEntity<EsListSum> titleSelect(@RequestParam(value = "id") String id,
                                                 @RequestParam(value = "page", defaultValue = "1") int page,
                                                 @RequestParam(value = "size", defaultValue = "10") int size,
                                                 @RequestParam(value = "title", defaultValue = "10") String title){

        int pageSize;
        if (page==0){
            pageSize=0;
        }else {
            pageSize=page-1;
        }
        return ResponseEntity.ok(privateService.titleSelect(id,pageSize,size,title));
    }


    /**
     *阅读页设置收藏
     * @param eventId            事件id
     * @param id                人员id
     */
    @ApiOperation(value = "事件置顶")
    @PostMapping("/collection")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="String", paramType = "query",required = true),
            @ApiImplicitParam(name="eventId",value="事件id",dataType="String", paramType = "query",required = true,example = "1"),
            @ApiImplicitParam(name="collection",value="是否收藏",dataType="int", paramType = "query",required = true,example = "1")
    })
    public ResponseEntity<BouncedMessage> collection(@RequestParam(value = "id")String id,
                                                     @RequestParam(value = "eventId")String eventId,
                                                     @RequestParam(value = "collection")int collection
                              ){
        return ResponseEntity.ok(eventService.placedCollection(eventId,id,collection));
    }

    /**
     * 查看事件的时候
     * @param id 人员id
     * @param eventId 事件id
     * @param readState 是否阅读过  判读是否阅读过  否修改 阅读状态
     * @return
     */
    @ApiOperation(value = "修改事件状态")
    @PostMapping("/readsStatus")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="String", paramType = "query",required = true),
            @ApiImplicitParam(name="eventId",value="事件id",dataType="String", paramType = "query",required = true,example ="1"),
            @ApiImplicitParam(name="readState",value="是否阅读过",dataType="int", paramType = "query",required = true,example="1")
    })

    public ResponseEntity readsStatus(@RequestParam(value = "id") String id,
                                              @RequestParam(value = "eventId")String eventId,
                                              @RequestParam(value = "readState")int readState
    ){
        eventService.readsStatus(id,eventId,readState);
        HashMap map=new HashMap(10);
        map.put("msg","事件状态修改成功");
        return ResponseEntity.ok(map);
    }

    @ApiOperation(value = "人员登入第一次的数据触发,之后的数据推送")
    @PostMapping("/push")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="String", paramType = "query",required = true)
    })

    public ResponseEntity loginFirstOneManualPush(@RequestParam(value = "id") String id
    ){

        privateService.loginFirstOneManualPush(id);
        return ResponseEntity.ok().build();
    }


}
