package com.zjty.tynotes.job.status.controller;

import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.status.service.EventService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * @author zjm
 */
@RequestMapping("/read")
@RestController
@Slf4j
public class TaskController {

    @Autowired
    EventService eventService;
    @GetMapping("/task/{id}/{id1}/{id2}/{id3}")
    public void task(@PathVariable("id") String id, @PathVariable("id1") String id1, @PathVariable("id2") String id2, @PathVariable("id3") String id3){
        log.info("开始");
        Map<Integer,List<String>> map =new HashMap<>();
        List<String> s=new ArrayList<>();
        List<String> f1=new ArrayList<>();
        f1.add(id);

        List<String> z=new ArrayList<>();
        z.add(id1);
        s.add(id2);
        List<String> g=new ArrayList<>();
        g.add(id3);
        map.put(1,s);
        map.put(0,g);

        Map<String,List<String>> map1=new HashMap<>();
        map1.put("inspector",s);
        map1.put("viewer",g);
        map1.put("executor",z);
        map1.put("publisher",f1);

        eventService.saveTakePushEvent("test1","第一次",id,id1,map,new Date(),WorkStatus.UNDERWAY,map1,"添加新的事件");
        eventService.saveTakePushEvent("test2","第2次",id,id1,map,new Date(),WorkStatus.UNDERWAY,map1,"添加新的事件");
        eventService.saveTakePushEvent("test3","第3次",id,id1,map,new Date(),WorkStatus.UNDERWAY,map1,"添加新的事件");
        eventService.saveTakePushEvent("test4","第4次",id,id1,map,new Date(),WorkStatus.UNDERWAY,map1,"添加新的事件");

    }

    @GetMapping("/task1")
    public void task1(){
        eventService.readsStatus("z","test1",1);
        eventService.readsStatus("z","test2",1);
        eventService.readsStatus("f","test1",1);
        eventService.readsStatus("f","test2",1);
    }

    @GetMapping("/task2")
    public void task2(){
        Set<String> s=new HashSet<>();
        s.add("s1");
        s.add("s2");
        s.add("g1");
        s.add("g2");
        s.add("z");
        eventService.addMessage("f","test1",s,new Date(),1,"f对test1时间留言");
        eventService.addMessage("f","test2",s,new Date(),1,"f对test2时间留言");
    }

    @GetMapping("/task3")
    public void task3(){
        Set<String> s=new HashSet<>();
        s.add("s1");
        s.add("s2");
        s.add("g1");
        s.add("g2");
        s.add("z");

        eventService.upDateStateEvent("test1","f",s,new Date(),WorkStatus.UNDERWAY,"f修改了事件状态");
         eventService.upDateStateEvent("test2","f",s,new Date(),WorkStatus.UNDERWAY,"f修改了事件状态");
    }
    @GetMapping("/task4")
    public void task4(){
        List<String> s=new ArrayList<>();
        List<String> f1=new ArrayList<>();
        f1.add("f");

        List<String> z=new ArrayList<>();
        z.add("z");
        s.add("s1");
        s.add("s3");
        List<String> g=new ArrayList<>();
        g.add("g1");
        g.add("g3");

        Map<String,List<String>> map1=new HashMap<>();
        map1.put("inspector",s);
        map1.put("viewer",g);
        map1.put("executor",z);
        map1.put("publisher",f1);


        Set<String> s1=new HashSet<>();
        s1.add("s1");
        s1.add("s2");
        s1.add("g1");
        s1.add("g2");
        s1.add("z");

        eventService.addFollowersEvent("f","test1",s1,"第一次",new Date(),1,WorkStatus.UNDERWAY,map1,"修改事件");
        //eventService.addFollowersEvent("test2","第2次",new Date(),1,"q",0,1);
    }
}
