package com.zjty.tynotes.job.status.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * 提供前端阅读页面的事件集合
 */
@ApiModel(value = "EventTitle对象",description="提供阅读页面的事件列表")
public class EventTitle {
     //事件标题

     @ApiModelProperty(value = "事件标题",name = "title",example = "这是一个事件的标题")
     private String title;

     //留言条数

     @ApiModelProperty(value = "留言条数",name = "messageCount")
     private int messageCount;

     //更新时间

     @ApiModelProperty(value = "更新时间(毫秒)",name = "updateTime")
     private Long updateTime;

     //事件状态 （进行中）假设１进行中　２．已提交　３．已完结

     @ApiModelProperty(value = "事件状态（进行中）",name = "state",example = "underway")
     private String state;

     //是否已读（0已读,1未读）

     @ApiModelProperty(value = "是否已读（0已读,1未读）",name = "readState",example = "1")
     private int readState;

     //事件id

     @ApiModelProperty(value = "事件id",name = "id")
     private String id;

     //是否收藏（0否,1是）

     @ApiModelProperty(value = "是否收藏（0否,1是）",name = "collection",example = "０")
     private int collection;

     //在这个事件担任的角色（身份）

     @ApiModelProperty(value = "担任的角色（身份）",name = "identity",hidden = true)
     private int identity;

     //是否是发布者（0,不是,1是）

     @ApiModelProperty(value = "是否是发布者",name = "release",hidden = true)
     private int release;

     //执行人名称

     @ApiModelProperty(value = "执行人名称",name = "executor",example = "mcj1")
     private String executor;

     //审核人名称

     @ApiModelProperty(value = "审核人名称",name = "inspector",example = "[\"id\",\"id\"]")
     private List<String> inspector;

     //最近一次的操作

     @ApiModelProperty(value = "最近一次的操作",name = "latestNews",example = "root留言")
     private String latestNews;

     //发布者

     @ApiModelProperty(value = "发布者",name = "publisher",example = "root")
     private String publisher;

     //关注者

     @ApiModelProperty(value = "关注者",name = "viewer",example = "[\"id\",\"id\"]")
     private List<String> viewer;
     /*get --------------------------------- set*/

     public int getRelease() {
      return release;
     }

     public void setRelease(int release) {
      this.release = release;
     }

     public String getTitle() {
      return title;
     }

     public void setTitle(String title) {
      this.title = title;
     }

     public Long getUpdateTime() {
      return updateTime;
     }

     public void setUpdateTime(Long updateTime) {
      this.updateTime = updateTime;
     }

     public String getState() {
      return state;
     }

     public void setState(String state) {
      this.state = state;
     }

     public int getReadState() {
      return readState;
     }

     public void setReadState(int readState) {
      this.readState = readState;
     }

     public String getId() {
      return id;
     }

     public void setId(String id) {
      this.id = id;
     }

     public int getCollection() {
      return collection;
     }

     public void setCollection(int collection) {
      this.collection = collection;
     }

     public int getIdentity() {
      return identity;
     }

     public void setIdentity(int identity) {
      this.identity = identity;
     }

     public int getMessageCount() {
      return messageCount;
     }

     public void setMessageCount(int messageCount) {
      this.messageCount = messageCount;
     }


        public String getExecutor() {
            return executor;
        }

        public void setExecutor(String executor) {
            this.executor = executor;
        }

        public List<String> getInspector() {
            return inspector;
        }

        public void setInspector(List<String> inspector) {
            this.inspector = inspector;
        }

        public String getPublisher() {
            return publisher;
        }

        public void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        public List<String> getViewer() {
            return viewer;
        }

        public void setViewer(List<String> viewer) {
            this.viewer = viewer;
        }

        public String getLatestNews() {
      return latestNews;
     }

     public void setLatestNews(String latestNews) {
      this.latestNews = latestNews;
     }

     /*构造方法*/

     public EventTitle(String title, int messageCount, Long updateTime, String state, int readState, String id, int collection, int identity) {
      this.title = title;
      this.messageCount = messageCount;
      this.updateTime = updateTime;
      this.state = state;
      this.readState = readState;
      this.id = id;
      this.collection = collection;
      this.identity = identity;
     }

     public EventTitle() { }

     public EventTitle(String title, int messageCount, Long updateTime, String state, int readState, String id, int collection, int identity, int release, String executor, List<String> inspector, String latestNews, String publisher, List<String> viewer) {
            this.title = title;
            this.messageCount = messageCount;
            this.updateTime = updateTime;
            this.state = state;
            this.readState = readState;
            this.id = id;
            this.collection = collection;
            this.identity = identity;
            this.release = release;
            this.executor = executor;
            this.inspector = inspector;
            this.latestNews = latestNews;
            this.publisher = publisher;
            this.viewer = viewer;
     }



}
