package com.zjty.tynotes.job.status.service;

import com.zjty.tynotes.job.status.entity.BouncedMessage;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author zjm
 */

public interface EventService {

    /**
     * 添加数据到redis（分别安人员id来进行） ->取出数据->推送数据
     * @param eventId 事件id
     * @param eventTitle 事件标题
     * @param id 发布者
     * @param map　３种角色的ｉｄ集合
     * @param updateTime　更新时间
     * @param state　事件状态
     * @param executorId　执行人ｉｄ
     * @param mapName 执行人名称
     * @param latestNews  对任务的操作
     *
     */

    void saveTakePushEvent(String eventId, String eventTitle, String id, String executorId, Map<Integer, List<String>> map, Date updateTime, String state, Map<String, List<String>> mapName,String latestNews);


    /**
     *新留言
     * @param id　留言人的Ｉｄ
     * @param eventId　事件id
     * @param ids　推送人员的ｉｄ（相关人员ｉｄ）
     * @param updateTime　更新时间
     * @param messageCount　留言条数
     * @param latestNews 对任务的操作
     */
    void  addMessage(String id, String eventId, Set<String> ids, Date updateTime, int messageCount, String latestNews);


    /**
     * 更新事件的状态
     * @param eventId　事件id
     * @param id　操作者ｉｄ
     * @param ids　推送人员的ｉｄ（相关人员ｉｄ）
     * @param updateTime　更新时间
     * @param state　事件状态
     * @param latestNews 对任务的操作
     */
    void  upDateStateEvent(String eventId, String id, Set<String> ids, Date updateTime, String state, String latestNews);

    /**
     * 　添加审核　－　关注者
     * @param operationId 操作者id
     * @param eventId　事件id
     * @param ids 事件相关人员id
     * @param eventTitle 事件标题
     * @param updateTime　更新时间
     * @param messageCount　留言条数
     * @param state 事件的状态
     * @param mapName 执行人名称
     * @param latestNews 最近的一次对任务的操作
     */

    void  addFollowersEvent(String operationId, String eventId, Set<String> ids, String eventTitle, Date updateTime, int messageCount, String state, Map<String, List<String>> mapName, String latestNews);

    /**
     * 设置收藏 和取消收藏
     * @param eventId      事件id
     * @param id          人员id
     * @param collection　是否收藏　
     * @return 操作状态
     */

    BouncedMessage placedCollection(String eventId, String id, int collection);

    /**
     * 查看事件的时候
     * @param id 人员id
     * @param eventId 事件id
     * @param readState 是否阅读过  判读是否阅读过  否修改 阅读状态
     */
    void readsStatus(String id, String eventId, int readState);

}
