package com.zjty.tynotes.job.status.service;

import com.zjty.tynotes.job.status.entity.EsListSum;
import com.zjty.tynotes.job.status.entity.EventTitle;

import java.util.List;

/**
 * @author zjm
 */
public interface PrivateService {
    /**
     * 代办事件查询
     *
     * @param id   　人员id
     * @param page 　页码
     * @param size 　每页显示的条数
     * @return 事件对象集合
     */
    EsListSum selectCommission(String id, int page, int size);


    /**
     * 已提交事件查询
     *
     * @param id   　人员id
     * @param page 　页码
     * @param size 　每页显示的条数
     * @return 事件对象集合
     */
    EsListSum selectSubmit(String id, int page, int size);


    /**
     * 其他事件查询
     *
     * @param id   　人员id
     * @param page 　页码
     * @param size 　每页显示的条数
     * @return 事件对象集合
     */
    EsListSum selectOther(String id, int page, int size);

    /**
     * 收藏事件
     *
     * @param id   　人员id
     * @param page 　页码
     * @param size 　每页显示的条数
     * @return 给前端对象集合 和条数
     */
    EsListSum selectCollection(String id, int page, int size);

    /**
     * 标题查询
     *
     * @param id   　人员id
     * @param page 　页码
     * @param size 　每页显示的条数
     * @param title 事件的标题
     * @return 给前端对象集合 和条数
     */
    EsListSum titleSelect(String id, int page, int size, String title);

    /**
     * 人员登入　第一次的数据　接口触发
     * @param id 人员ｉｄ
     */
    void loginFirstOneManualPush(String id);
}
