package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.status.entity.ActionHistory;
import com.zjty.tynotes.job.status.entity.NoteResource;
import com.zjty.tynotes.job.status.repository.ActionHistoryRepository;
import com.zjty.tynotes.job.status.service.BusinessTreeManagement;
import com.zjty.tynotes.job.status.service.EventService;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.pas.service.impl.UserServiceImpl;
import com.zjty.tynotes.search.subject.service.EsUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-13
 */
@Service
@Slf4j
public class BusinessTreeManagementImpl implements BusinessTreeManagement {

    @Autowired
    private WorkService workService;

    @Autowired
    private EventService eventService;

    @Autowired
    private IUserService iUserService;

    @Autowired
    private ActionHistoryRepository actionHistoryRepository;

    @Override
    public void saveAction(String id, String taskId, int action, Date date, String msg) {
        log.info("[TREE] 获取action，参数为id：{}，taskID：{}，action：{}", id, taskId, action);
        NoteResource noteResource = new NoteResource(id, taskId, action, date);
        dealActionMsg(noteResource, msg);

    }

    @Override
    public void dealActionMsg(NoteResource noteResource, String msg) {
        Work work = workService.findById(noteResource.getTaskId());
        String status = work.getStatus();

        String name = iUserService.findUserById(noteResource.getId()).getUsername();

        List<String> publisher = new ArrayList<>();
        publisher.add(work.getPublisher());
        List<String> executor = new ArrayList<>();
        executor.add(work.getExecutor());

        Map<String,List<String>> nameMap = new HashMap<>(4);
        nameMap.put("publisher", publisher);
        nameMap.put("executor", executor);
        nameMap.put("inspector", work.getChecker());
        nameMap.put("viewer", work.getFollower());

        Set<String> setRs = new HashSet<>();
        setRs.add(work.getPublisher());
        setRs.add(work.getExecutor());
        setRs.addAll(work.getFollower());
        setRs.addAll(work.getChecker());
        setRs.remove(noteResource.getId());


        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName(name);
        actionHistory.setDate(noteResource.getDate());
        actionHistory.setMsg(msg);
        actionHistory.setTaskId(noteResource.getTaskId());


//                *               1 -> 执行人发布任务
//                *               2 -> 执行人提交任务
//                *               3 -> 审核人退回已提交任务
//                *               4 -> 审核人完结任务
//                *               5 -> 修改审核人
//                *               6 -> 修改关注人
//                *               7 -> 对事件留言
        switch (noteResource.getAction()) {
            case 1:

                Map<Integer, List<String>> map = new HashMap<>(2);
                map.put(1, work.getChecker());
                map.put(0, work.getFollower());

                eventService.saveTakePushEvent(work.getId(), work.getTitle(),
                        work.getPublisher(), work.getExecutor(), map,work.getUpdateTime(),
                        status, nameMap, name + "新建了任务");
                actionHistory.setActionMsg(name + "新建了任务");
                actionHistoryRepository.save(actionHistory);
                log.info("[TREE] {}新建任务，执行人id是{}", name, work.getPublisher());
                break;

            case 2:
                eventService.upDateStateEvent(work.getId(),
                        noteResource.getId(),
                        setRs,
                        work.getUpdateTime()
                        ,status,
                        name + "提交了任务");
                actionHistory.setActionMsg(name + "提交了任务");
                actionHistoryRepository.save(actionHistory);
                log.info("[TREE] {}提交了任务", name);
                break;

            case 3:
                eventService.upDateStateEvent(work.getId(),
                        noteResource.getId(),
                        setRs,
                        noteResource.getDate(),
                        status,
                        name + "退回了提交事件");
                actionHistory.setActionMsg(name + "退回了提交事件");
                actionHistoryRepository.save(actionHistory);
                log.info("[TREE] {}退回了任务", name);
                break;

            case 4:
                eventService.upDateStateEvent(work.getId(),
                        noteResource.getId(),
                        setRs,
                        noteResource.getDate(),
                        status,
                        name + "完结了任务");
                actionHistory.setActionMsg(name + "完结了任务");
                actionHistoryRepository.save(actionHistory);
                log.info("[TREE] {}完结了任务", name);
                break;

            case 5:
                eventService.addFollowersEvent(noteResource.getId(),
                        work.getId(),
                        setRs,
                        work.getTitle(),
                        noteResource.getDate(),
                        work.getComment().size(),
                        status,
                        nameMap,
                        name + "修改了审核人");
                actionHistory.setActionMsg(name + "修改了审核人");
                actionHistoryRepository.save(actionHistory);
                log.info("[TREE] {}修改了审核人", name);
                break;

            case 6:

                eventService.addFollowersEvent(noteResource.getId(),
                        work.getId(),
                        setRs,
                        work.getTitle(),
                        noteResource.getDate(),
                        work.getComment().size(),
                        status,
                        nameMap,
                        name + "修改了关注人");
                actionHistory.setActionMsg(name + "修改了关注人");
                actionHistoryRepository.save(actionHistory);
                log.info("[TREE] {}修改了关注者", name);
                break;

            case 7:
                eventService.addMessage(noteResource.getId(),
                        work.getId(),
                        setRs,
                        noteResource.getDate(),
                        work.getComment().size(), name + "对任务留言了");
                actionHistory.setActionMsg(name + "对任务留言了");
                actionHistoryRepository.save(actionHistory);
                log.info("[TREE] {}对任务留言了", name);
                break;

            default:
                log.warn("[es] 状态处理模块传入参数有误");
                break;
        }
    }
}
