package com.zjty.tynotes.job.status.service.impl;
import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.status.entity.BouncedMessage;
import com.zjty.tynotes.job.status.entity.EventTitle;
import com.zjty.tynotes.job.status.entity.RoleSum;
import com.zjty.tynotes.job.status.service.EventService;
import com.zjty.tynotes.job.status.utils.JacksonUtil;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.entity.EsSource;
import com.zjty.tynotes.search.subject.service.EsUtil;
import com.zjty.tynotes.sms.service.MessageTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author zjm
 */
@Service
@Slf4j
public class EventServiceImpl implements EventService {
    @Autowired
    private RedisTemplate<String,Object> redisTemplate;

    @Autowired
    MessageTemplateService messageTemplateService;

    @Autowired
    EsUtil esUtil;

    @Autowired
    IUserService iUserService;


    /**
     * releaseFalg boolean 发布者 和 审核者 是否是同一个人
     * falg boolean 发布者 和 执行人 是否是同一个人
     * @param eventId 事件id
     * @param eventTitle 事件标题
     * @param id 发布者
     * @param executorId　执行人ｉｄ
     * @param map　３种角色的ｉｄ集合
     * @param updateTime　更新时间
     * @param state　事件状态
     * @param mapName 执行人名称
     * @param latestNews  对任务的操作
     */
    @Override
    public void saveTakePushEvent(String eventId, String eventTitle, String id, String executorId, Map<Integer, List<String>> map, Date updateTime, String state,Map<String,List<String>> mapName,String latestNews) {
        Long time=updateTime.getTime();
        boolean releaseFalg=false;
        boolean falg=false;
        EventTitle event=new EventTitle(eventTitle,0,time,state,1,eventId,0,0,0,mapName.get("executor").get(0),mapName.get("inspector"),latestNews,mapName.get("publisher").get(0),mapName.get("viewer"));

        for (String i:map.get(0)){
            log.info("关注者{}",i);
             event.setIdentity(2);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+i,event);
            List<Object> list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+i,0,-1);
            assert list != null;
            pushData(i,JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}",i, JacksonUtil.toJSon(statisticalRoleCount(list)));
            asynchronousAddEs(Constants.REDIS_EVENT+i,event);
        }

        if (mapName.get("executor").get(0).equals(id)){
            log.info("执行者 和 发布者是同一人 {}",id);
            falg=true;
            event.setRelease(2);
            event.setIdentity(1);
            event.setReadState(1);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+executorId,event);
            List<Object> list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+executorId,0,-1);
            assert list != null;
            pushData(executorId,JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}",executorId, JacksonUtil.toJSon(statisticalRoleCount(list)));
            asynchronousAddEs(Constants.REDIS_EVENT+executorId,event);
        }

        for (String i:map.get(1)){
            if (i.equals(id)){
                log.info("发布者{}",i);
                event.setRelease(1);
                event.setIdentity(3);
                event.setReadState(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+i,event);
                releaseFalg=true;
                List<Object> list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+i,0,-1);
                assert list != null;
                pushData(i,JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}",i, JacksonUtil.toJSon(statisticalRoleCount(list)));
                asynchronousAddEs(Constants.REDIS_EVENT+i,event);
            }else {
                log.info("审核者{}",i);
                event.setRelease(0);
                event.setReadState(1);
                event.setIdentity(3);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + i, event);
                List<Object> list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+i,0,-1);
                assert list != null;
                pushData(i,JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}",i, JacksonUtil.toJSon(statisticalRoleCount(list)));
                asynchronousAddEs(Constants.REDIS_EVENT+i,event);
            }
        }
        if (!releaseFalg && !falg){
            log.info("发布者id{}",id);
            event.setReadState(0);
            event.setIdentity(4);
            event.setRelease(0);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+id,event);
            List<Object> list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
            assert list != null;
            pushData(id,JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}",id, JacksonUtil.toJSon(statisticalRoleCount(list)));
            asynchronousAddEs(Constants.REDIS_EVENT+id,event);
        }
        //这里写执行者
        if (!falg) {
            log.info("执行人id{}", executorId);
            event.setIdentity(1);
            event.setReadState(1);
            event.setRelease(0);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + executorId, event);
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + executorId, 0, -1);
            assert list != null;
            pushData(executorId, JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}", executorId, JacksonUtil.toJSon(statisticalRoleCount(list)));
            asynchronousAddEs(Constants.REDIS_EVENT + executorId, event);
        }
    }


    @Override
    public void addMessage(String id, String eventId, Set<String> ids, Date updateTime, int messageCount, String latestNews) {
        Long time=updateTime.getTime();
        List<Object> list=  redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        assert list != null;
        for (Object title:list){
             EventTitle event= (EventTitle) title;
             if (event.getId().equals(eventId)){
                 redisTemplate.opsForList().remove(Constants.REDIS_EVENT+id,1,event);
                 event.setMessageCount(messageCount);
                 event.setUpdateTime(time);
                 event.setLatestNews(latestNews);
                 redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+id,event);
                 asynchronousAddEs(Constants.REDIS_EVENT+id,event);
             }
        }
        pushData(id,JacksonUtil.toJSon(statisticalRoleCount(list)));
        log.info("{}这里发送{}",id, JacksonUtil.toJSon(statisticalRoleCount(list)));

        for (String i:ids){
           list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+i,0,-1);
           int j=0;
            assert list != null;
            while (j<list.size()){
               EventTitle event= (EventTitle) list.get(j);
               if (event.getId().equals(eventId)){
                   redisTemplate.opsForList().remove(Constants.REDIS_EVENT+i,1,event);
                   event.setLatestNews(latestNews);
                   event.setReadState(1);
                   event.setMessageCount(messageCount);
                   event.setUpdateTime(time);
                   redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+i,event);
                   asynchronousAddEs(Constants.REDIS_EVENT+i,event);
               }
               j++;
           }
            pushData(i,JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}",i, JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
    }



    @Override
    public void upDateStateEvent(String eventId,String id, Set<String> ids, Date updateTime,String state,String latestNews) {
        Long time=updateTime.getTime();
        List<Object> list=  redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        assert list != null;
        for (Object title:list){
            EventTitle event= (EventTitle) title;
            if (event.getId().equals(eventId)){
                redisTemplate.opsForList().remove(Constants.REDIS_EVENT+id,1,event);
                event.setState(state);
                event.setLatestNews(latestNews);
                event.setUpdateTime(time);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+id,event);
                asynchronousAddEs(Constants.REDIS_EVENT+id,event);
            }
        }
        pushData(id,JacksonUtil.toJSon(statisticalRoleCount(list)));
        log.info("{}这里发送{}",id, JacksonUtil.toJSon(statisticalRoleCount(list)));

        for (String i:ids){
            list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+i,0,-1);
            int j=0;
            assert list != null;
            while (j<list.size()){
                EventTitle event= (EventTitle) list.get(j);
                if (event.getId().equals(eventId)){
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT+i,1,event);
                    event.setLatestNews(latestNews);
                    event.setReadState(1);
                    event.setState(state);
                    event.setUpdateTime(time);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+i,event);
                    asynchronousAddEs(Constants.REDIS_EVENT+i,event);
                }
                j++;
            }
            pushData(i,JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}",i, JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
    }



    @Override
    public void addFollowersEvent(String operationId,String eventId,Set<String> ids,String eventTitle,Date updateTime, int messageCount,String state,Map<String,List<String>> mapName,String latestNews) {
        Long time=updateTime.getTime();
        List<Object> list=  redisTemplate.opsForList().range(Constants.REDIS_EVENT+operationId,0,-1);
        EventTitle yevent = new EventTitle();
        assert list != null;
        for (Object title:list){
            EventTitle  event= (EventTitle) title;
            if (event.getId().equals(eventId)){
                yevent=event;
                redisTemplate.opsForList().remove(Constants.REDIS_EVENT+operationId,1,event);
                event.setExecutor(mapName.get("executor").get(0));
                event.setInspector(mapName.get("inspector"));
                event.setPublisher(mapName.get("publisher").get(0));
                event.setViewer(mapName.get("viewer"));
                event.setLatestNews(latestNews);
                event.setUpdateTime(time);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+operationId,event);
                asynchronousAddEs(Constants.REDIS_EVENT+operationId,event);
            }
        }
        pushData(operationId,JacksonUtil.toJSon(statisticalRoleCount(list)));

            //关注者
            List<String> viewerCommon=yevent.getViewer().stream().filter(mapName.get("viewer")::contains).collect(Collectors.toList());
            List<String> viewerDeleteList = yevent.getViewer().stream().filter(item->!viewerCommon.contains(item)).collect(Collectors.toList());
            List<String> viewerAddList = mapName.get("viewer").stream().filter(item->!viewerCommon.contains(item)).collect(Collectors.toList());
            EventTitle event = new EventTitle(eventTitle, messageCount, time, state, 1, eventId, 0, 2, 0, mapName.get("executor").get(0), mapName.get("inspector"), "", mapName.get("publisher").get(0), mapName.get("viewer"));
            addRemove(viewerAddList, viewerDeleteList, event);
            //审核者
            List<String> inspectorCommon=yevent.getInspector().stream().filter(mapName.get("inspector")::contains).collect(Collectors.toList());
            List<String> inspectorDeleteList= yevent.getInspector().stream().filter(item->!inspectorCommon.contains(item)).collect(Collectors.toList());
            List<String> inspectorAddList=mapName.get("inspector").stream().filter(item->!inspectorCommon.contains(item)).collect(Collectors.toList());
            inspectorDeleteList.removeAll(inspectorCommon);
            inspectorAddList.removeAll(inspectorCommon);
            event=new EventTitle(eventTitle,messageCount,time,state,1,eventId,0,3,0,mapName.get("executor").get(0),mapName.get("inspector"),"",mapName.get("publisher").get(0),mapName.get("viewer"));
            addRemove(inspectorAddList,inspectorDeleteList,event);


       for (String i:ids){
         list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+i,0,-1);
           int j=0;
           assert list != null;
           while (j<list.size()){
                  event= (EventTitle) list.get(j);
               if (event.getId().equals(eventId)){
                   redisTemplate.opsForList().remove(Constants.REDIS_EVENT+i,1,event);
                   event.setExecutor(mapName.get("executor").get(0));
                   event.setInspector(mapName.get("inspector"));
                   event.setPublisher(mapName.get("publisher").get(0));
                   event.setViewer(mapName.get("viewer"));
                   event.setLatestNews(latestNews);
                   event.setReadState(1);
                   event.setUpdateTime(time);
                   redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+i,event);
                   asynchronousAddEs(Constants.REDIS_EVENT+i,event);
               }
               j++;
           }
           pushData(i,JacksonUtil.toJSon(statisticalRoleCount(list)));
       }
    }

    @Override
    public BouncedMessage placedCollection(String eventId, String id, int collection) {
        if (collection==1){
            List<Object> list=  redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
            assert list != null;
            for (Object title:list){
                EventTitle event= (EventTitle) title;
                if (event.getId().equals(eventId)){
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT+id,1,event);
                    event.setCollection(1);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+id,event);
                    asynchronousAddEs(Constants.REDIS_EVENT+id,event);
                }
            }
            return new BouncedMessage("收藏事件成功");
        }else {
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
            assert list != null;
            for (Object title : list) {
                EventTitle event = (EventTitle) title;
                if (event.getId().equals(eventId)) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + id, 1, event);
                    event.setCollection(0);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + id, event);
                    asynchronousAddEs(Constants.REDIS_EVENT+id,event);
                }
            }
        }
        return new BouncedMessage("取消收藏成功");
    }

    @Override
    public void readsStatus(String id, String eventId, int readState) {
         List<Object> list=  redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        if (readState==1){
            assert list != null;
            for (Object title:list){
                EventTitle event= (EventTitle) title;
                if (event.getId().equals(eventId)){
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT+id,1,event);
                    event.setReadState(0);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+id,event);
                    asynchronousAddEs(Constants.REDIS_EVENT+id,event);
                }
            }
            pushData(id,JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}",id, JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
    }




    /*       --------------------------------------------　私有方法区　------------------------------------------------        */



    private void addRemove(List<String> addList,List<String> deleteList,EventTitle event){
            if (addList!=null){
                log.info("{}添加集合大小",addList.size());
                for (String id:addList) {
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + id, event);
                    List<Object> glist = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
                    assert glist != null;
                    asynchronousAddEs(Constants.REDIS_EVENT+id,event);
                    pushData(id,JacksonUtil.toJSon(statisticalRoleCount(glist)));
                    log.info("{}这里发送{}", id, JacksonUtil.toJSon(statisticalRoleCount(glist)));
                }
            }


            if (deleteList !=null) {
                log.info("{}删除集合大小",deleteList.size());
                for (String id : deleteList) {
                    List<Object> glist = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
                    assert glist != null;
                    for (Object title : glist) {
                        EventTitle eventg = (EventTitle) title;
                        if (eventg.getId().equals(event.getId())) {
                            redisTemplate.opsForList().remove(Constants.REDIS_EVENT + id, 1, eventg);
                            esUtil.delete(Constants.REDIS_EVENT + id,event.getId());
                        }
                    }
                    glist = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
                    assert glist != null;
                    pushData(id,JacksonUtil.toJSon(statisticalRoleCount(glist)));
                    log.info("{}这里发送{}", id, JacksonUtil.toJSon(statisticalRoleCount(glist)));
                }
            }

    }




    private EsSource eventToEs(EventTitle title) {
        EsSource esSource = new EsSource();
        Map<String, Object> objectMap = new HashMap<>(20);
        objectMap.put("title", title.getTitle());
        objectMap.put("messageCount", title.getMessageCount());
        objectMap.put("updateTime", title.getUpdateTime());
        objectMap.put("state", title.getState());
        objectMap.put("readState", title.getReadState());
        objectMap.put("id", title.getId());
        objectMap.put("collection", title.getCollection());
        objectMap.put("identity", title.getIdentity());
        objectMap.put("release", title.getRelease());
        objectMap.put("executor", title.getExecutor());
        objectMap.put("inspector", title.getInspector());
        objectMap.put("latestNews", title.getLatestNews());
        objectMap.put("publisher", title.getPublisher());
        objectMap.put("viewer", title.getViewer());
        esSource.setId(title.getId());
        esSource.setJsonMap(objectMap);
        return esSource;
    }

    private void asynchronousAddEs(String index,EventTitle eventTitle){
        CompletableFuture.runAsync(() -> {
             esUtil.save(index, eventToEs(eventTitle));
            log.info("异步写入es完成");
        });

    }


    private   RoleSum statisticalRoleCount(List<Object> list){
        int role1=0,role2=0,role3=0;
        int unread1=0,unread2=0,unread3=0;
        for (Object object:list) {
            EventTitle eventTitle= (EventTitle) object;
            switch (eventTitle.getIdentity()) {
                case 1:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getRelease()==2){
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                                role3=role3+1;
                            }
                            if (eventTitle.getReadState()==1){
                                unread1=1;
                            }
                            role1=role1+1;
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getRelease()==2){
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                                role3=role3+1;
                            }
                            if (eventTitle.getReadState()==1){
                                unread2=1;
                            }
                            role2=role2+1;
                            break;
                        default:
                    }
                    break;
                case 2:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        default:
                    }
                    break;
                case 3:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getRelease()==1){
                                role3=role3+1;
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                            }else {
                                if (eventTitle.getReadState() == 1) {
                                    unread3 = 1;
                                }
                                role3 = role3 + 1;
                            }
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getRelease()==1){
                                role3=role3+1;
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                            }
                            if (eventTitle.getReadState()==1){
                                unread1=1;
                            }
                            role1=role1+1;
                            break;
                        default:
                    }
                    break;
                case 4:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        default:
                    }
                    break;
                default:
            }
        }
        return new RoleSum(unread1,role1,unread2,role2,unread3,role3);
    }

    private void pushData(String id,String payload){
        log.info("[Status,pushData] 传入的id值为：{} ", id);
        String receive=  iUserService.findUserById(id).getUsername();
        if (receive!=null) {
            messageTemplateService.beingPushed(receive, "/topic/note", payload);

        }else {
            log.info("{}数据库查询不到，请检查",id);
        }
    }
}
