package com.zjty.tynotes.job.status.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.status.entity.EsListSum;
import com.zjty.tynotes.job.status.entity.EventTitle;
import com.zjty.tynotes.job.status.entity.RoleSum;
import com.zjty.tynotes.job.status.service.PrivateService;
import com.zjty.tynotes.job.status.utils.JacksonUtil;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.entity.CollectionRs;
import com.zjty.tynotes.search.subject.entity.EsSearchArg;
import com.zjty.tynotes.search.subject.service.EsUtil;
import com.zjty.tynotes.sms.service.MessageTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
/**
 * @author zjm
 */
@Service
@Slf4j
public class PrivateServiceImpl implements PrivateService {
    @Autowired
    EsUtil esUtil;

    @Autowired
    RedisTemplate<String,Object> redisTemplate;

    @Autowired
    MessageTemplateService messageTemplateService;
    @Autowired
    IUserService iUserService;

    @Override
    public EsListSum selectCommission(String id, int page, int size) {
        CollectionRs collection=esUtil.getPresentTask(id,new EsSearchArg.Builder().page(page).size(size).build());
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);

        assert objectList != null;
        List<EventTitle> list=redisToEs(objectList,collection.getSource());
        list.sort(Comparator.comparing(EventTitle::getUpdateTime).reversed());
        return new EsListSum(collection.getTotal(),list);
//                JacksonUtil.readValue(s, new TypeReference<List<EventTitle>>() {
//        });
    }


    @Override
    public EsListSum selectSubmit(String id, int page, int size) {
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        CollectionRs collection=esUtil.getApplyTask(id,new EsSearchArg.Builder().page(page).size(size).build());
        assert objectList != null;
        List<EventTitle> list=redisToEs(objectList,collection.getSource());
        list.sort(Comparator.comparing(EventTitle::getUpdateTime).reversed());
        return new EsListSum(collection.getTotal(),list);
    }

    @Override
    public EsListSum selectOther(String id, int page, int size) {
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        CollectionRs collection=esUtil.getContactTask(id,new EsSearchArg.Builder().page(page).size(size).build());

        assert objectList != null;
        List<EventTitle> list=redisToEs(objectList,collection.getSource());
        list.sort(Comparator.comparing(EventTitle::getUpdateTime).reversed());
        return new EsListSum(collection.getTotal(),list);
    }

    @Override
    public EsListSum selectCollection(String id, int page, int size) {
        CollectionRs collection =esUtil.getCollection(id,page,size);
        String s = JacksonUtil.toJSon(collection.getSource());
     List<EventTitle> eventTitles= JacksonUtil.readValue(s, new TypeReference<List<EventTitle>>() {
        });
        assert eventTitles != null;
        eventTitles.sort(Comparator.comparing(EventTitle::getUpdateTime).reversed());
        return new EsListSum(collection.getTotal(),eventTitles);
    }

    @Override
    public EsListSum titleSelect(String id, int page, int size, String title) {
        CollectionRs collection=esUtil.getTaskByTitle(id,title,page,size);
        String s = JacksonUtil.toJSon(collection.getSource());
        List<EventTitle> eventTitles= JacksonUtil.readValue(s, new TypeReference<List<EventTitle>>() {
        });
        assert eventTitles != null;
        eventTitles.sort(Comparator.comparing(EventTitle::getUpdateTime).reversed());
        return new EsListSum(collection.getTotal(),eventTitles);
    }

    @Override
    public void loginFirstOneManualPush(String id) {
        log.info("redis :{}",Constants.REDIS_EVENT);
        List<Object> list= redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        assert list != null;
        RoleSum roleSum= statisticalRoleCount(list);
        String receive=iUserService.findUserById(id).getUsername();
        log.info("{}调用了id查询的接口",receive);
        if (receive!=null) {
            messageTemplateService.beingPushed(receive, "/topic/note", JacksonUtil.toJSon(roleSum));
        }else {
            log.info("{}数据库查询不到，请尝试",id);
        }
    }


    private List<EventTitle> redisToEs(List<Object> objectList,List<Map<String,Object>> esList){
        List<EventTitle> eventTitles=new ArrayList<>();
        for (Object obj:objectList){
            EventTitle eventTitle=(EventTitle)obj;
            for (Map<String,Object> map:esList){
                if (eventTitle.getId().equals(map.get("id"))){
                    eventTitles.add(eventTitle);
                }
            }
        }
        return eventTitles;
    }


    private   RoleSum statisticalRoleCount(List<Object> list){
        int role1=0,role2=0,role3=0;
        int unread1=0,unread2=0,unread3=0;
        for (Object object:list) {
            EventTitle eventTitle= (EventTitle) object;
            switch (eventTitle.getIdentity()) {
                case 1:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getRelease()==2){
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                                role3=role3+1;
                            }
                            if (eventTitle.getReadState()==1){
                                unread1=1;
                            }
                            role1=role1+1;
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getRelease()==2){
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                                role3=role3+1;
                            }
                            if (eventTitle.getReadState()==1){
                                unread2=1;
                            }
                            role2=role2+1;
                            break;
                        default:
                    }
                    break;
                case 2:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        default:
                    }
                    break;
                case 3:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getRelease()==1){
                                role3=role3+1;
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                            }else {
                                if (eventTitle.getReadState() == 1) {
                                    unread3 = 1;
                                }
                                role3 = role3 + 1;
                            }
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getRelease()==1){
                                role3=role3+1;
                                if (eventTitle.getReadState()==1){
                                    unread3=1;
                                }
                            }
                            if (eventTitle.getReadState()==1){
                                unread1=1;
                            }
                            role1=role1+1;
                            break;
                        default:
                    }
                    break;
                case 4:
                    switch (eventTitle.getState()){
                        case WorkStatus
                                .UNDERWAY:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        case WorkStatus
                                .COMMITTED:
                            if (eventTitle.getReadState()==1){
                                unread3=1;
                            }
                            role3=role3+1;
                            break;
                        default:
                    }
                    break;
                default:
            }
        }
        return new RoleSum(unread1,role1,unread2,role2,unread3,role3);
    }

}
