package com.zjty.tynotes.pas.dao;

import com.zjty.tynotes.pas.entity.User;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: mcj
 * @Date: 19-4-29 下午2:17
 * @Version 1.0
 */
public interface PasUserDao extends MongoRepository<User, String> {

    /**
     * 根据用户名查询用户对象
     * @param username 用户名
     * @param status 状态
     * @return User
     */
    User findAllByUsernameEqualsAndStatusEquals(String username,Integer status);

    /**
     * 根据用户姓名查询用户对象
     * @param name 用户姓名
     * @param status 删除状态
     * @return User
     */
    List<User> findAllByNameEqualsAndStatusEquals(String name,Integer status);

    /**
     * 根据用户名查询用户对象
     * @param status 状态
     * @return User
     */
    List<User> findAllByStatusEquals(Integer status);

    /**
     * 根据id集合搜索用户
     * @param ids id集合
     * @param status 删除状态
     * @return list
     */
    List<User> findAllByIdInAndStatusEquals(List<String> ids,Integer status);

    /**
     * 根据部门id查询用户
     * @param ids 部门id
     * @param status 删除状态
     * @return User
     */
    List<User> findAllByDepartIdInAndStatusEquals(List<String> ids,Integer status);

    /**
     * 查询未删除的人员
     * @param id 用户id
     * @param status 删除状态
     * @return User
     */
    User findAllByIdEqualsAndStatusEquals(String id,Integer status);

    /**
     * 根据id列表查询
     * @param ids id列表
     * @return list
     */
    List<User> findAllByIdIn(List<String> ids);

    /**
     * 根绝用户名查询用户
     * @param name
     * @return
     */
    List<User> findAllByUsername(String name);

    /**
     * 根据部门id查询用户
     * @param id
     * @return
     */
    List<User> findAllByDepartmentId(String id);

    /**
     * 根据部门列表查询用户
     * @param departmentIds
     * @return
     */
    List<User> findAllByDepartmentIdIn(List<String> departmentIds);


}
