package com.zjty.tynotes.weekly.subject.service.impl;

import com.zjty.tynotes.pas.dao.*;
import com.zjty.tynotes.pas.entity.*;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import com.zjty.tynotes.weekly.subject.service.UserManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @Author gwj
 * @create 2020/3/2 13:07
 */
@Service
public class UserManageServiceImpl implements UserManageService {

    @Autowired
    private PasUserDao pasUserDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RoleAuthorityDao roleAuthorityDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private DepartmentDao departmentDao;

    @Override
    public User findUserById(String id) {
        Optional<User> optional = pasUserDao.findById(id);
        User user = null;
        if(optional.isPresent()){
            user = optional.get();
            List<String> roleIds = new ArrayList<>();
            List<UserRole> userRoles = userRoleDao.findAllByUserId(user.getId());
            for (UserRole userRole : userRoles) {
                roleIds.add(userRole.getRoleId());
            }
            List<Role> roles = roleDao.findAllByIdIn(roleIds);
            user.setRoles(roles);
        }
        return user;
    }

    /**
     * 查询人员列表       待完成
     * @param pageRequest
     * @return
     */
    @Override
    public PageResponse<User> findUserList(PageRequest pageRequest) {
        List<User> users = new ArrayList<>();
        PageResponse<User> pageResponse = new PageResponse<>();
        pageResponse.setCurrentPage(pageRequest.getCurrentPage());
        pageResponse.setPageSize(pageRequest.getPageSize());
        if(pageRequest.getDeId()!=null){
            if(pageRequest.getSort()!=null && ("1").equals(pageRequest.getSort())){
                users = pasUserDao.findAllByDepartmentId(pageRequest.getId());
                if(pageRequest.getSort()!=null){
                    for (User user : users) {
                        //根据用户id查询任务数量
                    }
                }

            }else{

            }
            pageResponse.setTotalCount(users.size());
            pageResponse.setRows(users);
            pageResponse.build(users);
            return pageResponse;


        }else{
            List<Department> departmentList = findDepartmentList(pageRequest.getId());
            List<String> departmentIds = new ArrayList<>();
            for (Department department : departmentList) {
                departmentIds.add(department.getId());
            }
            users = pasUserDao.findAllByDepartmentIdIn(departmentIds);
        }
        return pageResponse;
    }


    /**
     * 查询可查看的部门列表
     * @param id
     * @return
     */
    @Override
    public List<Department> findDepartmentList(String id) {
        List<UserRole> userRoles = userRoleDao.findAllByUserId(id);
        List<String> roleIds = new ArrayList<>();
        for (UserRole userRole : userRoles) {
            roleIds.add(userRole.getRoleId());
        }
        List<Role> roles = roleDao.findAllByIdIn(roleIds);
        for (Role role : roles) {
            List<RoleAuthority> roleAuthorities = roleAuthorityDao.findAllByRoleId(role.getId());
            List<String> authorityIds = new ArrayList<>();
            for (RoleAuthority roleAuthority : roleAuthorities) {
                authorityIds.add(roleAuthority.getAuthorityId());
            }
            List<Authority> authorities = authorityDao.findAllByIdIn(authorityIds);
            role.setAuthorities(authorities);
        }

        List<Role> roleList = new ArrayList<>();
        for (Role role : roles) {
            List<Authority> authorities = role.getAuthorities();
            for (Authority authority : authorities) {
                if("查看人员".equals(authority.getName())){
                    roleList.add(role);
                }
            }
        }

        List<Department> departments = new ArrayList<>();
        if(roleList!=null){
            for (Role role : roleList) {
                String departmentId = role.getDepartmentId();
                List<Department> departmentList = departmentDao.findAllByParentId(departmentId);
                findDepartmentList(departments,departmentList);
            }
            return departments;
        }
        return departments;

    }

    /**
     * 待完成，需要任务提供接口
     * @param id
     * @param status
     * @return
     */
    @Override
    public List<Work> findUserWork(String id, String status) {
        List<Work> works = workDao.find(id,status);
        return works;
    }

    private List<Department> findDepartmentList(List<Department> des, List<Department> deps){
        for (Department department : deps) {
            if(!des.contains(department)){
                des.add(department);
            }
        }
        for (Department department : deps) {
            List<Department> departments = departmentDao.findAllByParentId(department.getId());
            if(departments!=null){
                findDepartmentList(des,departments);
            }
        }
        return des;
    }




}
