package com.zjty.tynotes.job.basic.service;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;


public interface ScoreCoefficientService {
    /**
     * 新增工作
     * 不可附带id
     * 判断上级任务id是否存在，存在者减去这次任务设置的分数
     * @param scoreCoefficient 考评对象
     * @return 新增对象的id
     */
    String add(ScoreCoefficient scoreCoefficient);

    /**
     * 修改工作
     * 必须附带id
     *
     * @param scoreCoefficient 考评对象
     * @return 更新对象的id
     */
    String modify(ScoreCoefficient scoreCoefficient);

    /**
     * 指定id的Work是否存在
     *
     * @param Id 指定id
     * @return 是否存在
     */
    Boolean idExists(String Id);



    /**
     * 查找指定id的Work
     *
     * @param id 指定id
     * @return ScoreCoefficient 对象
     */
    ScoreCoefficient findById(String id);



}
