package com.zjty.tynotes.job.basic.utils;

import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
@Service
public class WorkingTime {

    //设置上班时间：该处时间可以根据实际情况进行调整
    static float morningBegin = 9;//上午上班时间,小时
    static float morningEnd = 11.5f;//上午下班时间，小时
    static float eveningBegin = 13;//下午上班时间，小时
    static float eveningEnd = 17;//下午下班时间，小时

    static float noonBreak = eveningBegin-morningEnd;//中午休息时间
    static float eveningBreak = 24-eveningEnd+morningBegin;//晚上休息时间
    static float morningWork = morningEnd-morningBegin;//上午上班时间
    static float eveningWork = eveningEnd-eveningBegin;//下午上班时间
    static float operHours = morningWork + eveningWork;//一天上班时间




    @SuppressWarnings("deprecation")
    public static float findOperHours(List<Date> maps, Date startDate, Date endDate) throws ParseException {
        //用于格式化日期
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd ");
        Date startTime =startDate;
        Date endTime =endDate;
        double leaveDays = 0;
        //从startTime开始循环，若该日期不是节假日或者不是周六日则请假天数+1
        Date flag = startTime;//设置循环开始日期
        Calendar cal = Calendar.getInstance();

        //如果结束时间大于开始时间则返回0
        if(flag.compareTo(endTime) == 1) {

            return 0;
        }

        outer:while((getNowDate(flag)).compareTo(getNowDate(endTime)) == -1){
            cal.setTime(flag);
            for (Date map : maps){

                if((getNowDate(flag)).compareTo(map) == 0){
                    //跳出循环进入下一个日期
                    cal.add(Calendar.DAY_OF_MONTH, +1);
                    flag = cal.getTime();
                    continue outer;
                }
            }
            leaveDays = leaveDays + operHours;
            //日期往后加一天
            cal.add(Calendar.DAY_OF_MONTH, +1);
            flag = cal.getTime();
        }
        System.out.println("endTime.getHours()---"+endTime.getHours() +"------flag.getMinutes():" +flag.getMinutes());
        float endHours = endTime.getHours() + (float)endTime.getMinutes()/60;
        float startHours = flag.getHours() + (float)flag.getMinutes()/60;

        //时间在上午上班时间
        if(endHours > morningBegin && endHours <= morningEnd) {
            //结束时间在工作时间内  判断开始时间是否在上班时间之后
            if(startHours > morningBegin) {
                leaveDays = leaveDays + endHours - startHours;
            } else {
                leaveDays = leaveDays + endHours - morningBegin;
            }
        }
        //时间在中午休息时间则取上午上班时间
        if(endHours > morningEnd && endHours < eveningBegin) {
            if(startHours <= morningBegin) {
                leaveDays = leaveDays + morningEnd - morningBegin;
            } else if(startHours > morningBegin && startHours < morningEnd) {
                leaveDays = leaveDays + morningEnd - startHours;
            }
        }
        //时间大于中午休息时间则减去中午休息时间
        if(endHours > eveningBegin && endHours <= eveningEnd) {
            if(startHours < morningBegin) {
                leaveDays = leaveDays + endHours - morningBegin - noonBreak;
            } else if(startHours >= morningBegin && startHours <= morningEnd) {
                leaveDays = leaveDays + endHours - startHours - noonBreak;
            } else if(startHours > morningEnd && startHours <= eveningBegin) {
                leaveDays = leaveDays + endHours - eveningBegin;
            } else if(startHours > eveningBegin) {
                leaveDays = leaveDays + endHours - startHours;
            }
        }
        //时间大于晚上下班时间则去白天上班时间
        if(endHours > eveningEnd) {
            if(startHours < morningBegin) {
                leaveDays = leaveDays + eveningEnd - morningBegin - noonBreak;
            } else if(startHours >= morningBegin && startHours <= morningEnd) {
                leaveDays = leaveDays + eveningEnd - startHours - noonBreak;
            } else if(startHours > morningEnd && startHours <= eveningBegin) {
                leaveDays = leaveDays + eveningEnd - eveningBegin;
            } else if(startHours > eveningBegin) {
                leaveDays = leaveDays + eveningEnd - startHours;
            }
        }

        System.out.println("-------leaveDays----:"+leaveDays);
        return (float)(Math.round(leaveDays*100)/100.0);
    }


    public static List<Date> initHoliday() throws ParseException {
        List<Date> holidays = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        holidays.add(sdf.parse("2019-01-01"));
        holidays.add(sdf.parse("2019-01-05"));
        holidays.add(sdf.parse("2019-01-06"));
        return holidays;
    }

    public static Date getNowDate(Date date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(date);
        Date currentTime_2 = formatter.parse(dateString);
        return currentTime_2;
    }


}
