package com.zjty.tynotes.pas.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;

/**
 * @Author: mcj
 * @Date: 19-5-7 下午4:41
 * @Version 1.0
 */
@Api(tags = "用户管理权限管理模块",protocols = "http")
@RequestMapping("/pas/count")
@AutoDocument
@Controller
public class LoginController {

    @Autowired
    IUserService iUserService;

    @ApiOperation(value = "登陆失败计数",response = String.class)
    @PostMapping
    @ResponseBody
    public ResponseEntity login(@RequestBody String username){
        String s = iUserService.addUserCount(username);
        HashMap<Object, Object> map = new HashMap<>(16);
        map.put("msg",s);
        return ResponseEntity.ok(map);
    }

    @GetMapping("/login")
    public String login2(){
        return "login";
    }
}
