package com.zjty.tynotes.attendance.controller;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiAttendanceListRequest;
import com.dingtalk.api.request.OapiUserGetDeptMemberRequest;
import com.dingtalk.api.request.OapiUserGetRequest;
import com.dingtalk.api.response.OapiAttendanceListResponse;
import com.dingtalk.api.response.OapiUserGetDeptMemberResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.taobao.api.ApiException;
import com.zjty.tynotes.attendance.entity.CardResult;
import com.zjty.tynotes.attendance.task.CardTask;
import com.zjty.tynotes.attendance.task.MyInit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/27 13:47
 */
@RestController
@RequestMapping("/test")
public class TestController {
    @Autowired
    private CardTask cardTask;
    @Autowired
    private MyInit myInit;

    @GetMapping("/test")
    public ResponseEntity test(){
        List<CardResult> cardDetails = cardTask.getCardDetails();
        return ResponseEntity.ok(cardDetails);
    }

    @GetMapping("/dingUser")
    public ResponseEntity dingUser(){
        Long aLong = myInit.dingDepartmentIds.get(0);
        DingTalkClient client2 = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/getDeptMember");
        OapiUserGetDeptMemberRequest req = new OapiUserGetDeptMemberRequest();
        req.setDeptId(aLong+"");
        req.setHttpMethod("GET");
        OapiUserGetDeptMemberResponse rsp = null;
        List<String> userIds = null;
        try {
            rsp = client2.execute(req, myInit.token);
            userIds = rsp.getUserIds();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        System.out.println(rsp.getBody());

        DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/get");
        OapiUserGetRequest request = new OapiUserGetRequest();
        List<OapiUserGetResponse> responses = new ArrayList<>();
        userIds.forEach(str->{
            request.setUserid(str);
            request.setHttpMethod("GET");
            try {
                OapiUserGetResponse response = client.execute(request, myInit.token);
                responses.add(response);
            } catch (ApiException e) {
                e.printStackTrace();
            }
        });
        return ResponseEntity.ok(responses);
    }

}
