package com.zjty.tynotes.pas.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.pas.utils.LogoutUtil;
import com.zjty.tynotes.search.subject.service.EsUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import static org.springframework.http.ResponseEntity.*;

/**
 * @author mcj
 */
@Api(tags = "用户管理权限管理模块", protocols = "http")
@RestController
@RequestMapping("/pas/user")
@AutoDocument
public class UserController {

    @Autowired
    LogoutUtil logoutUtil;
    @Autowired
    IUserService iUserService;

    @ApiOperation(value = "查询所有用户", response = User.class)
    @GetMapping
    public ResponseEntity user() {
        List<User> all = iUserService.findAll();
        return ok(all);
    }


    @ApiOperation(value = "根据姓名查询用户", response = User.class)
    @GetMapping("/name/{name}")
    public ResponseEntity findUserByName(@PathVariable String name) {
        return ok(iUserService.findUserByName(name));
    }


    @ApiOperation(value = "用户登出")
    @GetMapping("/userLogout")
    public void logout() {
        logoutUtil.logout();
    }

    @ApiOperation(value = "删除用户")
    @DeleteMapping("/delete/{id}")
    public ResponseEntity delete(@PathVariable @NotNull String id) {
        iUserService.deleteUserById(id);
        return ok().build();
    }

    @ApiOperation(value = "更新任意用户信息")
    @PutMapping
    public ResponseEntity update(@RequestBody @NotNull User user) {
        User user1 = iUserService.updateUser(user);
        return ok(user1);

    }

//    @ApiOperation(value = "判断当前密码是否一致")
//    @PutMapping("/judgePassword")
//    public ResponseEntity updateSelf(@RequestBody @NotNull UserDTO user){
//        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
//        User principal = (User) authentication.getPrincipal();
//        User userByUsername = iUserService.findUserByUsername(principal.getUsername());
//        userByUsername.setPassword(user.getPassword());
//        return ok(iUserService.updateUser(userByUsername));
//    }


//    @ApiOperation(value = "更新当前用户密码")
//    @PutMapping("/password")
//    public ResponseEntity updateSelf(@RequestBody @NotNull UserDTO user){
//        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
//        User principal = (User) authentication.getPrincipal();
//        User userByUsername = iUserService.findUserByUsername(principal.getUsername());
//        userByUsername.setPassword(user.getPassword());
//        return ok(iUserService.updateUser(userByUsername));
//    }

    @ApiOperation(value = "新增用户", response = User.class)
    @PostMapping
    public ResponseEntity addUser(@RequestBody @Valid User user) {
        return ok(iUserService.addUser(user));
    }



    @ApiOperation(value = "根据id查询用户", response = User.class)
    @GetMapping("/findUser/{id}")
    public ResponseEntity findUser(@PathVariable("id") String id) {
        return ok(iUserService.findUserById(id));
    }

    @ApiOperation(value = "根据用户id查询该用户可发布id的人员", response = User.class)
    @GetMapping("/findUserList/{id}")
    public ResponseEntity findUserList(@PathVariable("id") String id) {
        String authoryName = "发布任务";
        return ok(iUserService.findUserList(id,authoryName));
    }

    @ApiOperation(value = "密码加密", response = User.class)
    @GetMapping("/encryPas")
    public ResponseEntity encryPas() {
        return ok(iUserService.encryPas());
    }

    @ApiOperation(value = "添加关联", response = User.class)
    @GetMapping("/addGuanLian")
    public ResponseEntity deleteRoot() {
        return ok(iUserService.deleteRoot());
    }

    @ApiOperation(value = "重置密码")
    @GetMapping("/replacePass/{id}")
    public ResponseEntity replacePass(@PathVariable String id) {
        boolean flag = iUserService.replacePass(id);
        if(flag){
            return ok("重置密码成功");
        }
        return ok("重置密码失败");
    }

    @ApiOperation(value = "查询该用户是否是某用户的上级,并且拥有修改任务权限")
    @GetMapping("/judgeParent/{id}/{userId}")
    public ResponseEntity judgeParent(@PathVariable String id,@PathVariable String userId) {
        boolean flag = iUserService.judgeParent(id,userId);
        return ok(flag);
    }



}
