package com.zjty.tynotes.union;

import org.apache.catalina.connector.Connector;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @author LJJ
 * on 2019-04-16
 */
@EnableSwagger2
@SpringBootApplication(scanBasePackages = {
        "com.zjty.tynotes.pas",
        "com.zjty.tynotes.fs",
        "com.zjty.tynotes.job",
        "com.zjty.tynotes.search",
        "com.zjty.tynotes.redis",
        "com.zjty.tynotes.weekly",
        "com.zjty.tynotes.misc",
        "com.zjty.tynotes.union"
//        , "com.zjty.tynotes.attendance"
})
@EnableCaching
@EnableScheduling
public class UnionApplication {
    public static void main(String[] args) {
        SpringApplication.run(UnionApplication.class, args);
    }
//    开始支持http
    @Bean
    public ServletWebServerFactory servletContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addAdditionalTomcatConnectors(createHTTPConnector());
        return tomcat;
    }

    private Connector createHTTPConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        //同时启用http（8080）、https（8443）两个端口
        connector.setScheme("http");
        connector.setSecure(false);
        connector.setPort(8084);
        connector.setRedirectPort(8289);
        return connector;
    }

}
