package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.service.ScoreCoefficientService;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.common.exception.WorkAttribution;
import com.zjty.tynotes.job.common.exception.WorkAttribution1;
import com.zjty.tynotes.job.status.entity.RedisPersonalWork;
import com.zjty.tynotes.job.status.service.RepairService;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.service.EsUtil;
import com.zjty.tynotes.sms.service.MessageTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class RepairServiceImpl implements RepairService {
    @Autowired
    private RedisTemplate<String,Object> redisTemplate;

    @Autowired
    MessageTemplateService messageTemplateService;

    @Autowired
    WorkService workService;

    @Autowired
    EsUtil esUtil;

    @Autowired
    ScoreCoefficientService scoreCoefficientService;
    @Autowired
    IUserService iUserService;
    @Override
    public void dbAllToRedis() {

        workService.findAll().forEach(this::dbToRedis);

    }

    private void dbToRedis(Work work){

        List<String> uIds=new ArrayList<>();
        Long time=new Date().getTime();
        String releaseName= iUserService.findUserById(work.getPublisher()).getUsername();
        String executorName= iUserService.findUserById(work.getExecutor()).getUsername();
        RedisPersonalWork personalWork=new RedisPersonalWork(work.getId(),time,work.getTitle(),work.getStatus(),releaseName,executorName,1,WorkAttribution.ME_WORK,"",work.getSuperiorId(),new ArrayList<>(),0,0);
        if (releaseName.equals(executorName)){
            if (work.getSuperiorId() == null){
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELEASE_WORK);
                personalWork.setExecutorEqualRelease(1);
                personalWork.setReadState(1);
                personalWork.setIsNotCommission(1);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
            }else {
                uIds = tests(work.getSuperiorId(), uIds);
                uIds.remove(work.getPublisher());
                uIds.remove(work.getExecutor());
                personalWork.setWorkAttribution(WorkAttribution1.ME_RESOLVE_WORK);
                personalWork.setExecutorEqualRelease(1);
                personalWork.setReadState(1);
                personalWork.setIsNotCommission(1);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;

            }

        }else {
            //发布人
            if (work.getSuperiorId() == null) {
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELEASE_WORK);
                switch (work.getStatus()){
                    case WorkStatus
                            .AUDIT:
                        personalWork.setIsNotCommission(1);
                        break;

                    case WorkStatus
                            .REVIEW:
                     ScoreCoefficient scoreCoefficient= scoreCoefficientService.findById(work.getId());
                    if (scoreCoefficient==null){
                        personalWork.setIsNotCommission(0);
                    }else {
                        personalWork.setIsNotCommission(1);
                    }
                    personalWork.setExecutorEqualRelease(0);

                        break;
                   default:
                       personalWork.setIsNotCommission(0);
                       break;
                }
                personalWork.setReadState(1);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

            } else {
                uIds = tests(work.getSuperiorId(), uIds);
                uIds.remove(work.getPublisher());
                uIds.remove(work.getExecutor());
                personalWork.setWorkAttribution(WorkAttribution1.ME_RESOLVE_WORK);
                personalWork.setExecutorEqualRelease(0);
                switch (work.getStatus()){
                    case WorkStatus
                            .AUDIT:
                        personalWork.setIsNotCommission(1);
                        break;

                    case WorkStatus
                            .REVIEW:
                        ScoreCoefficient scoreCoefficient= scoreCoefficientService.findById(work.getId());

                        if (scoreCoefficient==null){
                            personalWork.setIsNotCommission(0);
                        }else {
                            personalWork.setIsNotCommission(1);
                        }

                        break;
                    default:
                        personalWork.setIsNotCommission(0);
                        break;
                }
                personalWork.setReadState(1);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

            }
            //执行人 判断执行人是否有分解权限

            personalWork.setWorkAttribution(WorkAttribution1.ME_RECEIVE_WORK);
            personalWork.setReadState(1);
            switch (work.getStatus()){
                case WorkStatus
                        .ONGOING:
                    personalWork.setIsNotCommission(1);
                    break;

                case WorkStatus
                        .REVIEW:
                    ScoreCoefficient scoreCoefficient= scoreCoefficientService.findById(work.getId());

                    if (scoreCoefficient==null){
                        personalWork.setIsNotCommission(1);
                    }else {
                        personalWork.setIsNotCommission(0);
                    }
                    break;
                default:
                    personalWork.setIsNotCommission(0);
                    break;
            }
            personalWork.setExecutorEqualRelease(0);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getExecutor(), personalWork);


        }
        //有待修改
        if (uIds.size()!=0) {
            for (String id : uIds) {
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELATED_WORK);
                personalWork.setReadState(1);
                personalWork.setIsNotCommission(0);
                personalWork.setExecutorEqualRelease(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + id, personalWork);

            }
        }

    }

    private List<String> tests(String id,List<String> list){
        Work work=workService.findById(id);
        String workId=work.getSuperiorId();
        list.add(work.getPublisher());
        if (workId==null || "".equals(workId)){
            return list;
        }
        return tests(workId,list);
    }
}
