package com.zjty.tynotes.pas.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;

/**
 * @Author gwj
 * @create 2020/3/1 9:38
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "参数", description = "参数说明")
@Document(collection = "pas_config")
public class Config {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "参数名称不可为空")
    @ApiModelProperty(value = "参数名称",example = "上班时间")
    private String name;

    @ApiModelProperty(value = "权限描述",example = "。。。。")
    private String description;

    @ApiModelProperty(value = "参数值",example = "2020/2/10")
    private String value;

}
