package com.zjty.tynotes.pas.service.impl;

import com.zjty.tynotes.pas.dao.DepartmentDao;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.service.IDepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: mcj
 * @Date: 19-4-30 上午11:03
 * @Version 1.0
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class DepartmentServiceImpl implements IDepartmentService {

    @Autowired
    private DepartmentDao departmentDao;

    @Override
    public List<Department> findAll() {
        return departmentDao.findAll();
    }

    @Override
    public Department addDepartments(Department department) {
        return departmentDao.save(department);
    }

    @Override
    public void deleteAll() {
        departmentDao.deleteAll();
    }

    @Override
    public Department findOne(String id) {
        return departmentDao.findById(id).get();
    }

    @Override
    public List<Department> findList() {
        Department department = departmentDao.findByLevel("1");
        List<Department> departmentList = new ArrayList<>();
        departmentList.add(department);
        getDepartments(departmentList);
        return departmentList;
    }

    public void getDepartments(List<Department> departments) {
        for (Department department : departments) {
            List<Department> departmentList = departmentDao.findAllByParentId(department.getId());
            getDepartments(departmentList);
            department.setDepartments(departmentList);
        }
    }
}
