package com.zjty.tynotes.pas.service.impl;

import com.zjty.tynotes.pas.dao.*;
import com.zjty.tynotes.pas.entity.*;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import com.zjty.tynotes.pas.service.IDepartmentService;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.service.EsUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author mcj
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class UserServiceImpl implements IUserService {
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    RedisTemplate<String,Object> defaultRedisTpl;

    @Autowired
    PasUserDao pasUserDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RoleAuthorityDao roleAuthorityDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private DepartmentDao departmentDao;

    @Autowired
    EsUtil esUtil;


    @Override
    public User updateUser(User user) {
        List<UserRole> roles = new ArrayList<>();
        userRoleDao.deleteAllByUserId(user.getId());
        List<UserRole> userRoleList = new ArrayList<>();
        if(user.getRoles()!=null){
            for (Role role : user.getRoles()) {
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(role.getId());
                userRoleList.add(userRole);
            }
            roles = userRoleDao.saveAll(userRoleList);
        }
        List<String> roleId = new ArrayList<>();
        for (UserRole userRole : roles) {
            roleId.add(userRole.getId());
        }
        List<Role> roleList = roleDao.findAllByIdIn(roleId);
        user.setRoles(roleList);
        return user;
    }

    @Override
    public boolean deleteUserById(String id) {
        try {
            userRoleDao.deleteAllByUserId(id);
            pasUserDao.deleteById(id);
            return true;
        } catch (Exception e) {
            logger.error("mongodb删除用户失败");
        }
        return false;
    }

    @Override
    public User registerUser(User user) {
       if(findUserByUsername(user.getUsername())!=null){
          return user;
       }
        User save = pasUserDao.save(user);
        esUtil.createIndex(save.getId());
        return save;
    }

    @Override
    public User findUserByUsername(String username) {
        return pasUserDao.findByUsername(username);
    }

    @Override
    public List<User> findUserByName(String name) {
        List<User> users = pasUserDao.findAllByUsername(name);
        for (User user : users) {
            List<String> roleIds = new ArrayList<>();
            List<UserRole> userRoles = userRoleDao.findAllByUserId(user.getId());
            if(userRoles!=null){
                for (UserRole userRole : userRoles) {
                    String roleId = userRole.getRoleId();
                    roleIds.add(roleId);
                }
            }
            List<Role> roles = roleDao.findAllByIdIn(roleIds);
            user.setRoles(roles);
        }
        return users;
    }

    @Override
    public User findUserById(String id) {
        Optional<User> byId = pasUserDao.findById(id);
        List<String> roleIds = new ArrayList<>();
        User user = null;
        if(byId.isPresent()){
            user = byId.get();
            List<UserRole> userRoles = userRoleDao.findAllByUserId(user.getId());
            for (UserRole userRole : userRoles) {
                roleIds.add(userRole.getRoleId());
            }
            List<Role> roles = roleDao.findAllByIdIn(roleIds);
            user.setRoles(roles);
        }

        return user;
    }

    @Override
    public List<User> findUserByIds(List<String> ids) {
        return pasUserDao.findAllByIdIn(ids);
    }

    @Override
    public List<User> findAll() {
        List<User> users = pasUserDao.findAll();
        return users.stream().filter(user -> !"root".equals(user.getUsername())).collect(Collectors.toList());
    }

    @Override
    public String addUserCount(String username) {
        Object integer1 = defaultRedisTpl.opsForValue().get(username);

        Integer value = (Integer)integer1;
        String sysManagerName = "root";
        Integer count = 4;
        if(sysManagerName.equals(username)){
            return "";
        }
        if(integer1!=null){
           if(value>=count) {
               Query query = new Query(Criteria.where("username").is(username));
               Update update = new Update();
               update.set("clock", 1);
               mongoTemplate.updateFirst(query, update, User.class);
               return "账户已锁定";
           }else {
               Integer integer = value+1;
               defaultRedisTpl.opsForValue().set(username,integer,1,TimeUnit.DAYS);
               int i1 = 5 - integer;
               return "还有"+i1+"次机会";
           }
        }else {
            defaultRedisTpl.opsForValue().set(username,1);
            return "还有4次机会";
        }
    }

    @Override
    public User addUser(User user) {
        List<Role> roles = user.getRoles();
        List<UserRole> userRoles = new ArrayList<>();
        List<User> users = pasUserDao.findAll();
        for (User user1 : users) {
            if(user1.getUsername().equals(user.getUsername())){
                return null;
            }
        }
        User save = pasUserDao.save(user);
        List<String> ids = new ArrayList<>();
        if(roles!=null){
            for (Role role : roles) {
                String id = role.getId();
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(id);
                userRoles.add(userRole);
                ids.add(role.getId());
            }
            userRoleDao.saveAll(userRoles);
        }
        List<Role> roleList = roleDao.findAllByIdIn(ids);
        save.setRoles(roleList);
        return save;
    }

    @Override
    public boolean isHaveAuthority(String userId, String authorityName) {
        List<UserRole> userRoles = userRoleDao.findAllByUserId(userId);
        List<String> roleIds = new ArrayList<>();
        for (UserRole userRole : userRoles) {
            roleIds.add(userRole.getRoleId());
        }
        List<RoleAuthority> roleAuthorities = roleAuthorityDao.findAllByRoleIdIn(roleIds);
        List<String> authorityIds = new ArrayList<>();
        for (RoleAuthority roleAuthority : roleAuthorities) {
            authorityIds.add(roleAuthority.getAuthorityId());
        }
        List<Authority> authorities = authorityDao.findAllByIdIn(authorityIds);
        for (Authority authority : authorities) {
            if(authorityName.equals(authority.getName())){
                return true;
            }
        }
        return false;
    }

    @Override
    public List<User> findParentManager(String userId) {
        List<User> users = new ArrayList<>();
        List<UserRole> userRoles = userRoleDao.findAllByUserId(userId);
        List<String> roleIds = new ArrayList<>();
        for (UserRole userRole : userRoles) {
            String roleId = userRole.getRoleId();
            roleIds.add(roleId);
        }
        List<Role> roles = roleDao.findAllByIdIn(roleIds);
        for (Role role : roles) {
            List<String> roleIds2 = new ArrayList<>();
            List<String> userIds = new ArrayList<>();
            if(("1").equals(role.getIsLeader())){
                List<Role> roles1 = roleDao.findAllByDepartmentIdAndIsLeader(
                        role.getDepartmentId(), "0");
                for (Role role1 : roles1) {
                    roleIds2.add(role1.getId());
                }
                List<UserRole> userRoleList = userRoleDao.findAllByRoleIdIn(roleIds2);
                for (UserRole userRole : userRoleList) {
                    userIds.add(userRole.getUserId());
                }
                List<User> userList = pasUserDao.findAllByIdIn(userIds);
                users.addAll(userList);
            }else{
                Optional<Department> op = departmentDao.findById(role.getDepartmentId());
                if(op.isPresent()){
                    Department department = op.get();
                    String parentId = department.getParentId();
                    List<Role> roles1 = roleDao.findAllByDepartmentIdAndIsLeader(
                            role.getDepartmentId(), "0");
                    for (Role role1 : roles1) {
                        roleIds2.add(role1.getId());
                    }
                    List<UserRole> userRoleList = userRoleDao.findAllByRoleIdIn(roleIds2);
                    for (UserRole userRole : userRoleList) {
                        userIds.add(userRole.getUserId());
                    }
                    List<User> userList = pasUserDao.findAllByIdIn(userIds);
                    users.addAll(userList);
                }
            }
        }
        return null;
    }


}

