package com.zjty.tynotes.attendance.entity;

import com.dingtalk.api.response.OapiAttendanceListResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/24 9:18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "个人打卡信息", description = "个人打卡信息")
@Document(collection = "ding_card")
public class CardResult {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @ApiModelProperty(value = "钉钉打卡信息的id",example = "123qdsdd212")
    private Long dingCardId;

    @ApiModelProperty(value = "考勤类型",example = "上班、下班")
    private String checkType;

    @ApiModelProperty(value = "用户id",example = "1")
    private String userId;

    @ApiModelProperty(value = "时间结果",example = "Normal/Early/Late/Absenteeism/..")
    private String timeResult;

    @ApiModelProperty(value = "关联的审批id，当该字段非空时，表示打卡记录与请假、加班等审批有关",example = "1")
    private Integer approvId;

    @ApiModelProperty(value = "实际打卡时间,  用户打卡时间的毫秒数",example = "2020-03-20 10:10:5")
    private Date userCheckTime;

    @ApiModelProperty(value = "位置结果",example = "范围内/范围外/未打卡")
    private String locationResult;

    public CardResult(OapiAttendanceListResponse.Recordresult recordresult) {
        this.dingCardId = recordresult.getId();
        this.checkType = recordresult.getCheckType();
        this.timeResult = recordresult.getTimeResult();
        this.userCheckTime = recordresult.getUserCheckTime();
        this.locationResult = recordresult.getLocationResult();
    }
}
