package com.zjty.tynotes.job.status.entity;

import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@AutoDocument
@ApiModel(value = "webSocket对象")
public class RoleSum1 {

    /**
     * 我的代办任务 是否有未读　０　否　１有
     */
    @ApiModelProperty(value = "我的任务 是否未读",name = "meWorkUnread",example = "０　读了　１没读")
    private int meCommissionUnread;

    /**
     * 我的代办任务 条数
     */
    @ApiModelProperty(value = "我的任务 条数",name = "meWorkCount",example = "20")
    private int meCommissionCount;

    /**
     * 我的相关任务 是否有未读　０　否　１有
     */
    @ApiModelProperty(value = "我接收的任务 是否未读",name = "workId",example = "０　读了　１没读")
    private int meRelatedUnread;

    /**
     * 我的相关任务 条数
     */
    @ApiModelProperty(value = "我接收的任务 条数",name = "meReceiveCount",example = "1")
    private int meRelatedCount;


    /**
     * 我分解的任务  是否有未读　０　否　１有
     */
    @ApiModelProperty(value = "我分解的任务 是否未读",name = "workId",example = "０　读了　１没读")
    private int meResolveUnread;

    /**
     * 我分解的任务  条数
     */
    @ApiModelProperty(value = "我分解的任务  条数",name = "meResolveCount",example = "10")
    private int meResolveCount;

    /**
     * 我发布的任务  是否有未读　０　否　１有
     */
    @ApiModelProperty(value = "我发布的任务 是否未读",name = "workId",example = "０　读了　１没读")
    private int meReleaseUnread;

    /**
     * 我发布的任务  条数
     */
    @ApiModelProperty(value = " 我发布的任务  条数",name = "meReleaseCount",example = "12")
    private int meReleaseCount;

}
