package com.zjty.tynotes.pas.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.Authority;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.service.IDepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @author mcj
 */
@Api(tags = "用户管理权限管理模块",protocols = "http")
@RestController
@RequestMapping("/pas/department")
@AutoDocument
public class DepartController {

    @Autowired
    private IDepartmentService departmentService;

    @ApiOperation(value = "获得所有部门",response = Department.class)
    @GetMapping
    public ResponseEntity departments(){
        return ok(departmentService.findAll());
    }

    @ApiOperation(value = "添加部门",response = Department.class)
    @PostMapping
    public ResponseEntity addDepartments(@RequestBody @Valid Department department){

        return ok(departmentService.addDepartments(department));
    }

    @ApiOperation(value = "根据id查找部门")
    @PostMapping("/findOne")
    public ResponseEntity<Department> findDept(@RequestParam String id){
        return ok(departmentService.findOne(id));
    }


    @ApiOperation(value = "查找部门列表")
    @PostMapping("/findList")
    public ResponseEntity findList(){
        return ok(departmentService.findList());
    }



}
