package com.zjty.tynotes.fs.subject.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author LJJ
 * on 2019-04-23
 */
public interface FsUtil {

    /**
     * 存文件，返回一个默认id
     * 根据文件路径上传文件
     *
     * @param path     路径
     * @return 返回文件的id
     */
    String save(String path);

    /**
     * 存文件，返回一个默认id
     * 通过http servlet request获取文件进行保存
     *
     * @param httpServletRequest http servlet request
     * @return 文件的id
     */
    String save(HttpServletRequest httpServletRequest);

    /**
     * 根据id下载文件
     *
     * @param id       id
     * @param request  request
     * @param response response
     */
    void download(String id, HttpServletRequest request, HttpServletResponse response);

    /**
     * 根据文件id删除文件
     *
     * @param id 文件id
     */
    void delete(String id);

}
