package com.zjty.tynotes.job.basic.entity.database;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * <p>Description : tynotes
 * <p>Date : 2019/4/22 15:32
 * <p>@author : C
 * 附件
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "附件", description = "附件对象")
public class Attachment {

    /**
     * id
     */
    @Id
    @ApiModelProperty(value = "id", example = "id", notes = "若新增数据则不可附带id.更新已有数据则必须附带id.")
    private String id;

    @ApiModelProperty(value = "文件名", example = "test file")
    private String name;

    @ApiModelProperty(value = "文件后缀", example = "doc")
    private String suffix;
    /**
     * 上传者id
     */
    @NotNull
    @ApiModelProperty(value = "id", example = "user id")
    private String uploader;

    /**
     * 附件类型
     */
    @ApiModelProperty(value = "附件类型：init（初始）、work（工作）、comment（交流）", example = "init")
    private String type;

    /**
     * 上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "上传时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date time;

    /**
     * url资源
     */
    @NotNull
    @ApiModelProperty(value = "文件id.使用文件id调用文件系统的api可以获取文件.", example = "file id")
    private String fileId;

}
