package com.zjty.tynotes.job.basic.service.impl;//package com.zjty.tynotes.job.basic.service.impl;
//
//import com.google.common.collect.Lists;
//import com.zjty.tynotes.job.basic.entity.database.Comment;
//import com.zjty.tynotes.job.basic.entity.database.Work;
//import com.zjty.tynotes.job.basic.repository.CommentRepository;
//import com.zjty.tynotes.job.basic.service.CommentService;
//import com.zjty.tynotes.job.basic.service.WorkService;
//import com.zjty.tynotes.job.common.exception.BadRequestException;
//import com.zjty.tynotes.job.common.exception.NotFoundException;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import java.util.Date;
//import java.util.List;
//
//import static java.util.Objects.isNull;
//import static java.util.Objects.nonNull;
//
///**
// * <p>Description : note
// * <p>Date : 2019/4/24 14:25
// * <p>@author : C
// * 接口定义说明见↓
// *
// * @see CommentService
// */
//@Slf4j
//@Service
//public class CommentServiceImpl implements CommentService {
//
//    private final
//    CommentRepository commentRepository;
//
//    private final
//    WorkService workService;
//
//    @Autowired
//    public CommentServiceImpl(CommentRepository commentRepository, WorkService workService) {
//        this.commentRepository = commentRepository;
//        this.workService = workService;
//    }
//
//    @Override
//    public String add(Comment comment) {
//        //新增数据不可附带id
//        Boolean idMustNull = isNull(comment.getId());
//        if (idMustNull) {
//            //更新时间
//            comment.setCreateTime(new Date());
//            comment.setUpdateTime(new Date());
//            String saveId = commentRepository.save(comment).getId();
//            log.info(String.format("[job] 新增了id为 %s 的数据.", saveId));
//            return saveId;
//        } else {
//            String msg = "[job] 新增数据不可附带id.";
//            log.error(msg);
//            throw new BadRequestException(msg);
//        }
//
//    }
//
//    @Override
//    public String add(Comment comment, String workId) {
//        Boolean idMustNull = isNull(comment.getId());
//        if (idMustNull) {
//            Boolean workMustExist = workService.idExists(workId);
//            if (workMustExist) {
//                String saveId = commentRepository.save(comment).getId();
//                Work work = workService.findById(workId);
//                if (isNull(work.getComment())) {
//                    work.setComment(Lists.newArrayList());
//                }
//                work.getComment().add(saveId);
//                workService.modify(work);
//                log.info(String.format("[job] id为 %s 的留言已添加到id为 %s 的所属工作中.", saveId, workId));
//                return saveId;
//            } else {
//                String msg = "[job] 指定id的所属工作不存在.";
//                log.error(msg);
//                throw new NotFoundException(msg);
//            }
//        } else {
//            String msg = "[job] 新增数据不可附带id.";
//            log.error(msg);
//            throw new BadRequestException(msg);
//        }
//    }
//
//    @Override
//    public String modify(Comment comment) {
//        Boolean idMustExist = nonNull(comment.getId());
//        if (idMustExist) {
//            if (commentRepository.existsById(comment.getId())) {
//                comment.setUpdateTime(new Date());
//                String modifyId = commentRepository.save(comment).getId();
//                log.info(String.format("[job] 修改了id为 %s 的数据.", modifyId));
//                return modifyId;
//            } else {
//                String msg = "[job] 指定id的数据不存在.";
//                log.error(msg);
//                throw new NotFoundException(msg);
//            }
//        } else {
//            String msg = "[job] 修改必须在数据中附带id.";
//            log.error(msg);
//            throw new BadRequestException(msg);
//        }
//    }
//
//    @Override
//    public List<Comment> findAll() {
//        return commentRepository.findAll();
//    }
//
//    @Override
//    public List<Comment> findAll(List<String> ids) {
//        return Lists.newArrayList(commentRepository.findAllById(ids));
//    }
//
//    @Override
//    public void delete(String id) {
//
//    }
//
//    @Override
//    public void deleteAll() {
//        commentRepository.deleteAll();
//    }
//}
