package com.zjty.tynotes.pas.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import javax.validation.constraints.NotEmpty;

/**
 * @Author gwj
 * @create 2020/2/24 13:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "权限", description = "权限说明")
@Document(collection = "pas_authority")
public class Authority {

    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "权限名称不可为空")
    @ApiModelProperty(value = "权限名称",example = "修改人员")
    private String name;

    @ApiModelProperty(value = "权限描述",example = "。。。。")
    private String description;
}
