package com.zjty.tynotes.pas.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/1 10:33
 */
@Document(collection = "pas_day")
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "节假日配置", description = "节假日配置说明")
public class Day {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "节假日日期")
    @ApiModelProperty(value = "节假日日期",example = "2020/2/1")
    private Date date;

    @ApiModelProperty(value = "节假日描述",example = "为工作日还是休息日,默认0为工作日，1为休息日")
    private String status;

}
