package com.zjty.tynotes.pas.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/2/24 10:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "用户", description = "用户说明")
@Document(collection = "pas_user")
public class User implements UserDetails, Serializable {

    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "身份证号码不可为空")
    @ApiModelProperty(value = "身份证",example = "48489498131566546")
    private String idCard;

    @NotEmpty(message = "地址不可为空")
    @ApiModelProperty(value = "地址",example = "xx路xx楼xx号")
    private String address;

    @NotEmpty(message = "联系方式不可为空")
    @ApiModelProperty(value = "联系方式",example = "113665465465")
    private String phone1;

    @NotEmpty(message = "联系方式不可为空")
    @ApiModelProperty(value = "联系方式",example = "113665465465")
    private String phone2;

    @NotEmpty(message = "部门1不可为空")
    @ApiModelProperty(value = "部门1",example = "研发部")
    private String department1;

    @NotEmpty(message = "部门2不可为空")
    @ApiModelProperty(value = "部门2",example = "技术中心")
    private String department2;

    @NotEmpty(message = "部门3不可为空")
    @ApiModelProperty(value = "部门3",example = "工作簿项目组")
    private String department3;

    @NotNull(message = "岗位不可为空")
    @ApiModelProperty(value = "岗位",example = "1")
    private String jobs;

    @NotNull(message = "入职时间不可为空")
    @ApiModelProperty(value = "入职时间",example = "2019-01-45 12:12:12")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Integer entryTime;

    @NotEmpty(message = "邮箱不可为空")
    @ApiModelProperty(value = "邮箱",example = "123456789@qq.com")
    private String email;

    @NotEmpty(message = "用户名不可为空")
    @ApiModelProperty(value = "用户名",example = "username")
    private String username;
    @NotEmpty(message = "密码不可为空")
    @ApiModelProperty(value = "密码",example = "password")
    private String password;

    @NotEmpty(message = "部门id")
    @ApiModelProperty(value = "部门id",example = "1")
    private String departmentId;

    @Transient
    private List<Role> roles;

    @Transient
    private String status;//工作状态(0代表空闲  1代表忙碌)

//    @NotNull(message = "角色Id不可为空")
//    @ApiModelProperty(value = "角色id",example = "1")
//    private Integer roleId;


    @JsonIgnore
    List<SimpleGrantedAuthority> arrayList = new ArrayList();

    @Override
    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return arrayList;
    }

    @Override
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String toString() {
        return this.username;
    }
    @Override
    public int hashCode() {
        return username.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {return true;}
        if (!(obj instanceof com.zjty.tynotes.pas.entity.User)) {return false;}
        return this.toString().equals(obj.toString());
    }
}
