package com.zjty.tynotes.pas.service.impl;

import com.zjty.tynotes.pas.dao.ConfigDao;
import com.zjty.tynotes.pas.dao.DayDao;
import com.zjty.tynotes.pas.entity.Config;
import com.zjty.tynotes.pas.entity.Day;
import com.zjty.tynotes.pas.entity.vo.HolidayRequest;
import com.zjty.tynotes.pas.service.ConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/1 9:46
 */
@Service
public class ConfigServiceImpl implements ConfigService {
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private DayDao dayDao;

    @Override
    public List<Config> save(List<Config> configs) {
        return configDao.saveAll(configs);
    }

    @Override
    public List<Date> findHolidays(HolidayRequest holidayRequest) {
        List<Day> days = dayDao.findAllByStatusAndDateBetween("1",
                holidayRequest.getStartDate(), holidayRequest.getEndDate());
        List<Date> dates = new ArrayList<>();
        for (Day day : days) {
            dates.add(day.getDate());
        }
        return dates;
    }

    @Override
    public List<Day> setHolidays(List<Day> days) {
        Day day = days.get(0);
        Date date1 = day.getDate();
        int year = date1.getYear();
        int month = date1.getMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR,year);
        calendar.set(Calendar.MONTH,month);
        calendar.set(Calendar.DAY_OF_MONTH,1);
        Date firstDate = calendar.getTime();
        calendar.set(Calendar.DAY_OF_MONTH,-1);
        Date lastDate = calendar.getTime();
        return dayDao.saveAll(days);
    }

    @Override
    public Day setHoliday(Day day) {
        return dayDao.save(day);
    }

    @Override
    public List<Day> findHolidaysByMonth(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date1 = sdf.parse(date);
            int year = date1.getYear();
            int month = date1.getMonth();
            Calendar calendar = Calendar.getInstance();
            calendar.set(Calendar.YEAR,year);
            calendar.set(Calendar.MONTH,month);
            calendar.set(Calendar.DAY_OF_MONTH,1);
            Date firstDate = calendar.getTime();
            calendar.set(Calendar.DAY_OF_MONTH,-1);
            Date lastDate = calendar.getTime();
            return dayDao.findAllByDateBetween(firstDate,lastDate);
        } catch (ParseException e) {

        }
        return null;
    }
}
