package com.zjty.tynotes.union.service.impl;

import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.status.entity.EventTitle;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.entity.EsSource;
import com.zjty.tynotes.search.subject.service.EsUtil;
import com.zjty.tynotes.union.service.RedisToEsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * @author zjm
 */
@Service
public class RedisToEsServiceImpl implements RedisToEsService {
    @Autowired
    IUserService iUserService;

    @Autowired
    private RedisTemplate<String,Object> redisTemplate;

    @Autowired
    EsUtil esUtil;
    @Override
    public void saveEsToRedis() {
        List<User> users=iUserService.findAll();
        for (User user:users){
             esUtil.createIndex(user.getId());

           List<Object> objectList= redisTemplate.opsForList().range(Constants.REDIS_EVENT+user.getId(),0,-1);
           if (objectList==null){
               return;
           }
           for (Object obj:objectList){
               asynchronousAddEs(Constants.REDIS_EVENT+user.getId(),(EventTitle)obj);
           }

        }
    }

    private void asynchronousAddEs(String index,EventTitle eventTitle){

            esUtil.save(index, eventToEs(eventTitle));

    }

    private EsSource eventToEs(EventTitle title) {
        EsSource esSource = new EsSource();
        Map<String, Object> objectMap = new HashMap<>(20);
        objectMap.put("title", title.getTitle());
        objectMap.put("messageCount", title.getMessageCount());
        objectMap.put("updateTime", title.getUpdateTime());
        objectMap.put("state", title.getState());
        objectMap.put("readState", title.getReadState());
        objectMap.put("id", title.getId());
        objectMap.put("collection", title.getCollection());
        objectMap.put("identity", title.getIdentity());
        objectMap.put("release", title.getRelease());
        objectMap.put("executor", title.getExecutor());
        objectMap.put("inspector", title.getInspector());
        objectMap.put("latestNews", title.getLatestNews());
        objectMap.put("publisher", title.getPublisher());
        objectMap.put("viewer", title.getViewer());
        esSource.setId(title.getId());
        esSource.setJsonMap(objectMap);
        return esSource;
    }
}
