package com.zjty.tynotes.weekly.subject.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.weekly.subject.service.UserManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/2 13:04
 */
@Api(tags = "人员管理模块", protocols = "http")
@RestController
@RequestMapping("/manage/user")
@AutoDocument
public class UserManageController {
    @Autowired
    private UserManageService userManageService;


    @ApiOperation(value = "根据id查询用户", response = User.class)
    @GetMapping("/findUser/{id}")
    public ResponseEntity addUser(@RequestBody @Valid String id) {
        return ok(userManageService.findUserById(id));
    }

    //待完成
    @ApiOperation(value = "查询人员列表", response = User.class)
    @GetMapping("/findUser/{id}")
    public ResponseEntity findUserList(@RequestBody PageRequest pageRequest) {
        return ok(userManageService.findUserList(pageRequest));
    }

    @ApiOperation(value = "查询可查看部门列表", response = User.class)
    @GetMapping("/findDepartmentList/{id}")
    public ResponseEntity findDepartmentList(@PathVariable("id") String id) {
        return ok(userManageService.findDepartmentList(id));
    }

//    @ApiOperation(value = "查询人员任务详情", response = User.class)
//    @GetMapping("/findUserWork/{id}/{status}")
//    public ResponseEntity findUserWork(@PathVariable("id") String id,
//                                             @PathVariable("status") String status) {
//        return ok(userManageService.findUserWork(id,status));
//    }

}
