package com.zjty.tynotes.attendance.dao;

import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/24 15:23
 */
public interface ApprovalInformationDao extends MongoRepository<ApprovalInformation,String> {
    List<ApprovalInformation> findAllByUserId(String userId);


    List<ApprovalInformation> findAllByApprovalUserIdOneOrApprovalUserIdTwo(String userId);

    List<ApprovalInformation> findAllByStatusIn(List<String> statusList);

    ApprovalInformation findByUserIdAndStatusAndApprovalType(String userId, String status,String type);

    List<ApprovalInformation> findAllByUserIdAndLeaveStartTimeLessThanEqualAndLeaveEndTimeGreaterThanEqualAndStatus(String userId, Date startTime ,Date endTime,String status);

    ApprovalInformation findAllByUserIdAndLeaveStartTimeBeforeAndLeaveEndTimeBetweenAndApprovalTypeAndStatus(String userId, Date startTime,Date startTime1,Date endTime,String type,String status);

    ApprovalInformation findAllByUserIdAndLeaveStartTimeBetweenAndLeaveEndTimeAfterAndApprovalTypeAndStatus(String userId, Date startTime,Date endTime,Date endTime1,String type,String status);
}
