package com.zjty.tynotes.pas.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/2 11:02
 * @des 分页请求类
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageRequest {
    /**
     * 每页显示个数
     */
    private int pageSize;
    /**
     * 当前页数
     */
    private int currentPage;
    /**
     * 总页数
     */
    private int totalPage;
    /**
     * 总记录数
     */
    private int totalCount;

    /**
     * 访问人员id
     */
    private String id;

    /**
     * 查询条件:部门id(默认查询所有可查询的所有人员)
     */
    private String deId;

    /**
     * 查询条件:人员状态
     */
    private String status;

    /**
     * 查询条件:任务数量升降序(默认降序0  1升序)
     */
    private Integer sort;

    /**
     * 起始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;
}
