package com.zjty.tynotes.attendance.controller;

import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import com.zjty.tynotes.attendance.entity.WorkoverAppro;
import com.zjty.tynotes.attendance.entity.vo.request.PageRequestAtten;
import com.zjty.tynotes.attendance.service.ApprovalInformationService;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.base.advise.Content;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/24 15:35
 * 审批流程视图层
 */
@Api(tags = "考勤模块", protocols = "http")
@RestController
@RequestMapping("/attendance/approval")
@AutoDocument
public class ApprovalController {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalController.class);

    @Autowired
    private ApprovalInformationService approvalInformationService;

    @Content(value = "提交审批")
    @ApiOperation(value = "提交审批", response = ApprovalInformation.class)
    @PostMapping("/submit")
    public ResponseEntity submit(@RequestBody ApprovalInformation approvalInformation) {
        ApprovalInformation approvalInformation1 = approvalInformationService.addApproval(approvalInformation);
        if(approvalInformation1!=null){
            return ok(approvalInformation1);
        }
        return ok("提交审批失败，是否是调休，并且是否有加班时长");
    }

    @Content(value = "删除请假审批")
    @ApiOperation(value = "删除请假审批")
    @DeleteMapping("/delete/{id}")
    public ResponseEntity delete(@PathVariable("id") String id) {
        try {
            boolean b = approvalInformationService.deleteApproval(id);
            if(b){
                return ok("删除审批成功");
            }
        } catch (Exception e) {
            logger.error("删除审批失败，错误内容{}:",e.getMessage());
        }
        return ok("删除审批失败");
    }

    /**
     * userId为审核者id,id为审批id,approvalStatus为该审批者是否接受审批
     * @param userId
     * @param approvalInformation
     * @param approvalStatus
     * @return
     */
    @Content(value = "审核审批")
    @ApiOperation(value = "审核审批")
    @PostMapping("/audit/{userId}/{approvalStatus}")
    public ResponseEntity audit(@PathVariable String userId,@PathVariable String approvalStatus,
                                @RequestBody ApprovalInformation approvalInformation) {
        try {
            ApprovalInformation approvalInformation1 = approvalInformationService.auditApproval(userId,approvalStatus,approvalInformation);
            return ok(approvalInformation1);
        } catch (Exception e) {
            logger.error("审核审批失败，错误内容{}:",e.getMessage());
        }
        return ok("审核审批失败");
    }

    @ApiOperation(value = "查找所有我提交的审批")
    @PostMapping("findAllSubmitApproval")
    public ResponseEntity findAllSubmitApproval(@RequestBody PageRequestAtten pageRequest) {
        try {
            PageResponse<ApprovalInformation> pageResponse = approvalInformationService.findAllApproval(pageRequest);
            return ok(pageResponse);
        } catch (Exception e) {
            logger.error("查找自身提交的审批失败，错误内容{}:",e.getMessage());
        }
        return ok("查找自身提交的审批失败");
    }

    @ApiOperation(value = "查找所有我审核的审批")
    @PostMapping("/findAllAuditApproval")
    public ResponseEntity findAllAuditApproval(@RequestBody PageRequestAtten pageRequest) {
        try {
            PageResponse<ApprovalInformation> approvalInformations = approvalInformationService.findAllAuditApproval(pageRequest);
            return ok(approvalInformations);
        } catch (Exception e) {
            logger.error("查找所有我审核的审批失败，错误内容{}:",e.getMessage());
        }
        return ok("查找所有我审核的审批失败");
    }

    @Content(value = "提交加班申请")
    @ApiOperation(value = "提交加班申请", response = WorkoverAppro.class)
    @PostMapping("/submitWorkover")
    public ResponseEntity submitWorkover(@RequestBody WorkoverAppro workoverAppro) {
        WorkoverAppro workoverAppro1 = approvalInformationService.addWorkoverApproval(workoverAppro);
        if(workoverAppro1!=null){
            return ok(workoverAppro1);
        }
        return ok("提交审批失败，是否可有加班时长");
    }

    @Content(value = "审批加班申请")
    @ApiOperation(value = "审批加班申请", response = ApprovalInformation.class)
    @PostMapping("/approWorkover/{userId}/{status}")
    public ResponseEntity approWorkover(@RequestBody WorkoverAppro workoverAppro,
                                        @PathVariable String userId,@PathVariable String status) {
        WorkoverAppro workoverAppro1 = approvalInformationService.approWorkover(workoverAppro,userId,status);
        if(workoverAppro1!=null){
            return ok(workoverAppro1);
        }
        return ok("提交审批失败，是否可有加班时长");
    }

    @ApiOperation(value = "查找所有我提交的加班审批")
    @PostMapping("findAllSubmitWorkOverApproval")
    public ResponseEntity findAllSubmitWorkOverApproval(@RequestBody PageRequestAtten pageRequest) {
        try {
            PageResponse<WorkoverAppro> pageResponse = approvalInformationService.findAllSubmitWorkOverApproval(pageRequest);
            return ok(pageResponse);
        } catch (Exception e) {
            logger.error("查找所有我提交的加班审批失败，错误内容{}:",e.getMessage());
        }
        return ok("查找所有我提交的加班审批失败");
    }

    @ApiOperation(value = "查找所有我审核的加班审批")
    @PostMapping("/findAllAuditWorkOverApproval")
    public ResponseEntity findAllAuditWorkOverApproval(@RequestBody PageRequestAtten pageRequest) {
//        try {
            PageResponse<WorkoverAppro> pageResponse = approvalInformationService.findAllAuditWorkOverApproval(pageRequest);
            return ok(pageResponse);
//        } catch (Exception e) {
//            logger.error("查找所有我审核的加班审批失败，错误内容{}:",e.getMessage());
//        }
//        return ok("查找所有我审核的加班审批失败");
    }

    @ApiOperation(value = "申请单的选择部门")
    @GetMapping("/departSelect")
    public ResponseEntity findSelectDepartment() {
        try {
            List<Department> pageResponse = approvalInformationService.findSelectDepartment();
            return ok(pageResponse);
        } catch (Exception e) {
            logger.error("查找可选择部门失败，错误内容{}:",e.getMessage());
        }
        return ok("查找可选择部门失败");
    }

    @Content(value = "删除加班审批")
    @ApiOperation(value = "删除加班审批")
    @DeleteMapping("/deleteWorkover/{id}")
    public ResponseEntity deleteWorkover(@PathVariable("id") String id) {
        try {
            boolean b = approvalInformationService.deleteWorkover(id);
            if(b){
                return ok("删除加班审批成功");
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("删除加班审批失败，错误内容{}:",e.getMessage());
        }
        return ok("删除加班审批失败");
    }


}
