package com.zjty.tynotes.attendance.dao;

import com.zjty.tynotes.attendance.entity.WorkoverAppro;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/4/13 13:02
 */
@Repository
public interface WorkoverApproDao extends MongoRepository<WorkoverAppro,String> {
    WorkoverAppro findByUserIdAndStatusAndOverDate(String userId, String status, Date date);

    List<WorkoverAppro> findAllByGroupMenbersContainsAndStatusAndOverDate(String userId, String status, Date date);

    List<WorkoverAppro> findAllByUserId(String userId);

    List<WorkoverAppro> findAllByAuditIdAndStatusIn(String auditId,List<String> userIds);

    List<WorkoverAppro> findAllByStatusIn(List<String> userIds);

    List<WorkoverAppro> findAllByOverDate(Date date);
}
