package com.zjty.tynotes.attendance.entity.vo;

import com.zjty.tynotes.attendance.entity.AttendanceDetails;
import com.zjty.tynotes.attendance.entity.exl.DepartmentExl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author gwj
 * @create 2020/3/25 10:00
 */
@Data
@AllArgsConstructor
@ApiModel(value = "返回前台的个人考勤统计信息", description = "返回前台的个人考勤统计信息")
public class UserAttenVo {

    @ApiModelProperty(value = "用户编号",example = "1")
    private String userId;

    @ApiModelProperty(value = "用户姓名",example = "1")
    private String name;

    @ApiModelProperty(value = "应出勤天数",example = "1")
    private Integer attendanceDay;

    @ApiModelProperty(value = "实际出勤天数",example = "1")
    private Float realAttendanceDay;

    @ApiModelProperty(value = "调休天数",example = "1")
    private Float paidLeaveDay;

    @ApiModelProperty(value = "公出天数",example = "1")
    private Float outSideBusinessDay;

    @ApiModelProperty(value = "迟到天数",example = "1")
    private Integer lateDay;

    @ApiModelProperty(value = "迟到1",example = "1")
    private Integer lateOne;

    @ApiModelProperty(value = "迟到2",example = "1")
    private Integer lateTwo;

    @ApiModelProperty(value = "迟到3",example = "1")
    private Integer lateThree;

    @ApiModelProperty(value = "迟到4",example = "1")
    private Integer lateFour;

    @ApiModelProperty(value = "早退天数",example = "1")
    private Integer leaveEarlyDay;

    @ApiModelProperty(value = "出差天数",example = "1")
    private Float outWorkDay;

    @ApiModelProperty(value = "病假天数",example = "1")
    private Float sickLeaveDay;

    @ApiModelProperty(value = "事假天数",example = "1")
    private Float thingDay;

    @ApiModelProperty(value = "加班时长",example = "1")
    private Integer overWorkHours;

    @ApiModelProperty(value = "旷工天数",example = "1")
    private Float absenteeismDay;

    @ApiModelProperty(value = "备注",example = "1")
    private String details;


    public UserAttenVo() {
        this.attendanceDay = 0;
        this.realAttendanceDay = 0f;
        this.outSideBusinessDay = 0f;
        this.lateDay = 0;
        this.lateOne = 0;
        this.lateTwo = 0;
        this.lateThree = 0;
        this.lateFour = 0;
        this.leaveEarlyDay = 0;
        this.outWorkDay = 0f;
        this.sickLeaveDay = 0f;
        this.thingDay = 0f;
        this.overWorkHours = 0;
        this.absenteeismDay = 0f;
        this.paidLeaveDay = 0f;
    }


    public void computerRealAttendanceDay(){

        realAttendanceDay = attendanceDay - outSideBusinessDay - outWorkDay - sickLeaveDay - absenteeismDay - paidLeaveDay;

    }

    public DepartmentExl convert(){
        Float leaveDay = thingDay+sickLeaveDay;
        return new DepartmentExl(name,attendanceDay,realAttendanceDay,
                outSideBusinessDay,lateDay,leaveEarlyDay,outWorkDay,
                leaveDay,null);
    }


}
