package com.zjty.tynotes.attendance.service;

import com.zjty.tynotes.attendance.entity.vo.UserAttenList;
import com.zjty.tynotes.attendance.entity.vo.UserAttenVo;
import com.zjty.tynotes.attendance.entity.vo.UserOverWorkVo;
import com.zjty.tynotes.attendance.entity.vo.request.AttenRequest;
import com.zjty.tynotes.pas.entity.Department;

import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/24 14:56
 */
public interface AttendanceDetailsService {

    /**
     * 查询个人考勤
     * @param id
     * @return
     */
    UserAttenVo findPersonnel(AttenRequest id);

    /**
     * 查询部门考勤
     * @param request
     * @return
     */
    List<UserAttenVo> findDepartment(AttenRequest request);

    /**
     * 查询可查看的部门列表
     * @param id
     * @return
     */
    List<Department> findDepartmentList(String id);

    /**
     * 查找请假或者旷工、加班等等列表
     * @param request
     * @param type
     * @return
     */
    UserAttenList findAttenList(AttenRequest request, String type);

    /**
     * 查询加班时长
     * @param userId
     * @return
     */
    UserOverWorkVo findOverWork(String userId);

    /**
     * 清空加班时长
     */
    void clearUserWork();

    /**
     * 查询所有人加班时长
     * @param userId
     * @return
     */
    List<UserOverWorkVo> findAllOverWork(String userId);
}
