package com.zjty.tynotes.log.controller;

import com.zjty.tynotes.log.entity.Log;
import com.zjty.tynotes.log.entity.vo.LogPageRequest;
import com.zjty.tynotes.log.server.LogService;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.Authority;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/4/23 15:43
 */
@Api(tags = "日志管理模块",protocols = "http")
@RestController
@RequestMapping("/pas/log")
@AutoDocument
public class LogController {
    @Autowired
    private LogService logService;

    @ApiOperation("查询日志")
    @PostMapping("/findAllLogs")
    public ResponseEntity findAllLogs(@RequestBody LogPageRequest pageRequest){
        PageResponse<Log> logPageResponse = logService.findLogs(pageRequest);
        return ok(logPageResponse);
    }
}
