package com.zjty.tynotes.weekly.subject.controller;

import com.zjty.tynotes.log.entity.Log;
import com.zjty.tynotes.log.server.LogService;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.base.advise.Content;
import com.zjty.tynotes.pas.entity.Address;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import com.zjty.tynotes.weekly.subject.entity.vo.AddressRequest;
import com.zjty.tynotes.weekly.subject.entity.vo.Problem;
import com.zjty.tynotes.weekly.subject.entity.vo.SimpleUserVo;
import com.zjty.tynotes.weekly.subject.entity.vo.UserVo;
import com.zjty.tynotes.weekly.subject.service.UserManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/2 13:04
 */
@Api(tags = "人员管理模块", protocols = "http")
@RestController
@RequestMapping("/manage/user")
@AutoDocument
public class UserManageController {

    @Autowired
    private LogService logService;

    @Autowired
    private UserManageService userManageService;

    private static final Logger logger = LoggerFactory.getLogger(UserManageController.class);


    @ApiOperation(value = "根据id查询用户", response = User.class)
    @GetMapping("/findUser/{id}")
    public ResponseEntity findUser(@RequestBody @Valid String id) {
        return ok(userManageService.findUserById(id));
    }

    //待完成
    @ApiOperation(value = "查询人员列表", response = User.class)
    @PostMapping("/findUserList")
    public ResponseEntity findUserList(@RequestBody PageRequest pageRequest) {
        PageResponse<UserVo> userList = null;
        try {
            userList = userManageService.findUserList(pageRequest);
            return ok(userList);
        } catch (ParseException e) {
            e.printStackTrace();
            logger.error("查询人员列表失败:{}",e.getMessage());
        }
        return ok("查询人员列表失败");
    }

    @ApiOperation(value = "根据权限查询可查看部门列表", response = User.class)
    @GetMapping("/findDepartmentList/{id}")
    public ResponseEntity findDepartmentList(@PathVariable("id") String id) {
        return ok(userManageService.findDepartmentList(id));
    }

//    @ApiOperation(value = "查询人员任务详情", response = User.class)
//    @GetMapping("/findUserWork/{id}/{status}")
//    public ResponseEntity findUserWork(@PathVariable("id") String id,
//                                             @PathVariable("status") String status) {
//        return ok(userManageService.findUserWork(id,status));
//    }

    @Content(value = "更新当前用户自身信息")
    @ApiOperation(value = "更新当前用户自身信息")
    @PutMapping("/updateSelf")
    public ResponseEntity updateSelf(@RequestBody @NotNull User user){
        try {
            User userById = userManageService.findUserById(user.getId());
            User user1 = userManageService.updateSelf(user, userById);
            logService.saveLog(new Log(null,"更改自身信息",new Date(),user.getId(),user.getUsername()));
            return ok(user1);
        } catch (Exception e) {
            logger.error("更改当前用户自身信息失败");
        }
        return ok("更改当前用户信息失败");
    }

    @Content(value = "更新当前用户密码")
    @ApiOperation(value = "更新当前用户密码")
    @PutMapping("/password/{oldPass}")
    public ResponseEntity updatePassword(@PathVariable String oldPass,@RequestBody @NotNull User user){
        BCryptPasswordEncoder bCryptPasswordEncoder = new BCryptPasswordEncoder();
        System.out.println(oldPass);
        User userByUsername = userManageService.findfindUserByUsername(user.getUsername());
        System.out.println(userByUsername.getPassword());

        if(bCryptPasswordEncoder.matches(oldPass,userByUsername.getPassword())){
            System.out.println(true);
            userByUsername.setPassword(user.getPassword());
            boolean b = userManageService.updatePas(userByUsername);
            if(b){
                logService.saveLog(new Log(null,"更改密码",new Date(),user.getId(),user.getUsername()));
                return ok("更改密码成功");
            }
        }
        return new ResponseEntity("更改密码失败",HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value = "上传建议以及使用中的问题")
    @PostMapping
    public ResponseEntity submitProblem(@RequestBody Problem problem){
        return ok(userManageService.submitProblem(problem));
    }

    @ApiOperation(value = "查找建议以及使用中的问题")
    @GetMapping
    public ResponseEntity searchProblem(){
        return ok(userManageService.searchProblem());
    }

    @ApiOperation(value = "修改建议以及使用中的问题")
    @PutMapping
    public ResponseEntity putProblem(@RequestBody Problem problem){
        return ok(userManageService.putProblem(problem));
    }

    @ApiOperation(value = "查询通讯录基本信息")
    @PostMapping("/findAddressBook")
    public ResponseEntity findAddressBook(@RequestBody AddressRequest addressRequest){
        try {
            PageResponse pageResponse = userManageService.findAddressBook(addressRequest);
            return ok(pageResponse);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询通讯录信息失败");
        }
        return ok("查询通讯录信息失败");
    }

}
