package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.repository.ScoreCoefficientRepository;
import com.zjty.tynotes.job.basic.repository.WorkRepository;
import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.common.exception.WorkAttribution;
import com.zjty.tynotes.job.common.exception.WorkAttribution1;
import com.zjty.tynotes.job.status.entity.Personnel;
import com.zjty.tynotes.job.status.entity.RedisPersonalWork;
import com.zjty.tynotes.job.status.entity.vo.UserWorkData;
import com.zjty.tynotes.job.status.service.InternalService;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.service.EsUtil;
import com.zjty.tynotes.sms.service.MessageTemplateService;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@Service
public class InternalServiceImpl implements InternalService {

    @Autowired
    private RedisTemplate<String,Object> redisTemplate;

    @Autowired
    IUserService iUserService;

    @Autowired
    WorkRepository workRepository;
    @Autowired
    ScoreCoefficientRepository scoreCoefficientRepository;
    @Override
    public List<Personnel> personnels(List<String> list) {
        List<Personnel> personnels=new ArrayList<>();
        for (String id:list) {
            List<Object> lists = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
            int count=0;
            for (Object object:lists){

                RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
                if (redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RECEIVE_WORK && redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                    count++;
                }
                if (redisPersonalWork.getExecutorEqualRelease()==1&& redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                    count++;
                }
            }
            personnels.add(new Personnel(id,iUserService.findUserById(id).getUsername(),count));
        }
        return personnels;
    }

    @Override
    public int personnelWorkCount(String id) {
        List<Object> lists = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
        int count=0;
        for (Object object:lists){

            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            if (redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RECEIVE_WORK && redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                count++;
            }
            if (redisPersonalWork.getExecutorEqualRelease()==1&& redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                count++;
            }
        }

        return count;
    }

    @Override
    public UserWorkData personnelWorkMsg(String userId, Date startTime, Date endTime) {
        UserWorkData userWorkData=new UserWorkData();
        int countOngoing=0;
        int countFinished=0;
        Double countScore=0d;
        Double countWork=0d;
        List<Work> works=  workRepository.findByExecutorAndStateTimeBetween(userId,startTime,endTime);
        for (Work work:works){

            if (work.getStatus().equals(WorkStatus.ONGOING)){
                countOngoing++;
            }

            if (work.getStatus().equals(WorkStatus.FINISHED)||work.getStatus().equals(WorkStatus.DELETE)){
                countFinished++;
                if (work.getPWorkload()==1) {
                    ScoreCoefficient scoreCoefficient = scoreCoefficientRepository.findByWordId(work.getId());
                    countWork = countWork + scoreCoefficient.getEndWorkLoad();
                    countScore = countScore + (Integer.valueOf(scoreCoefficient.getJustScore4()) + Integer.valueOf(scoreCoefficient.getViceScore3())) / 2;
                }
            }
        }
        if (countFinished!=0){
            userWorkData.setAverageScore(countScore/countFinished);
            userWorkData.setAverageWorkNum(countWork/countFinished);
        }
        else {
            userWorkData.setAverageScore(0d);
            userWorkData.setAverageWorkNum(0d);
        }

        userWorkData.setCompletedNum(countOngoing);
        userWorkData.setUnCompletedNum(countOngoing);
        userWorkData.setUserId(userId);
      return userWorkData;
    }

    @Override
    public UserWorkData personnelWorkMsgAll(String userId) {
        UserWorkData userWorkData=new UserWorkData();
        int countOngoing=0;
        int countFinished=0;
        Double countScore=0d;
        Double countWork=0d;
        List<Work> works=  workRepository.findByExecutor(userId);
        for (Work work:works){

            if (work.getStatus().equals(WorkStatus.ONGOING)){
                countOngoing++;
            }

            if (work.getStatus().equals(WorkStatus.FINISHED)||work.getStatus().equals(WorkStatus.DELETE)){
                countFinished++;
                if (work.getPWorkload()==1) {
                    ScoreCoefficient scoreCoefficient = scoreCoefficientRepository.findByWordId(work.getId());
                    countWork = countWork + scoreCoefficient.getEndWorkLoad();
                    countScore = countScore + (Integer.valueOf(scoreCoefficient.getJustScore4()) + Integer.valueOf(scoreCoefficient.getViceScore3())) / 2;
                }
                }
        }
        if (countFinished!=0){
            userWorkData.setAverageScore(countScore/countFinished);
            userWorkData.setAverageWorkNum(countWork/countFinished);
        }
        else {
            userWorkData.setAverageScore(0d);
            userWorkData.setAverageWorkNum(0d);
        }
        userWorkData.setCompletedNum(countFinished);
        userWorkData.setUnCompletedNum(countOngoing);
        userWorkData.setUserId(userId);
        return userWorkData;
    }
}
