package com.zjty.tynotes.attendance.controller;

import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import com.zjty.tynotes.attendance.entity.vo.UserAttenList;
import com.zjty.tynotes.attendance.entity.vo.request.AttenRequest;
import com.zjty.tynotes.attendance.service.AttendanceDetailsService;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/25 9:12
 * @des 考勤信息统计
 */
@Api(tags = "考勤模块", protocols = "http")
@RestController
@AutoDocument
@RequestMapping("/attendance/info")
public class AttendanceController {
    @Autowired
    private AttendanceDetailsService attendanceDetailsService;


    @ApiOperation(value = "查询个人考勤信息", response = ApprovalInformation.class)
    @PostMapping("/personnel")
    public ResponseEntity personnel(@RequestBody AttenRequest request){
        return ok(attendanceDetailsService.findPersonnel(request));
    }

    @ApiOperation(value = "查询部门考勤信息", response = ApprovalInformation.class)
    @PostMapping("/department")
    public ResponseEntity department(@RequestBody AttenRequest request){
        return ok(attendanceDetailsService.findDepartment(request));
    }

    @ApiOperation(value = "查询某人的考勤列表(请假、调休等等)", response = ApprovalInformation.class)
    @PostMapping("/findAttenList/{type}")
    public ResponseEntity findAttenList(@RequestBody AttenRequest request,@PathVariable String type){
        UserAttenList userAttenList = attendanceDetailsService.findAttenList(request,type);
        return ok(userAttenList);
    }


}
