package com.zjty.tynotes.attendance.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Author gwj
 * @create 2020/3/24 9:32
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "钉钉部门", description = "钉钉部门")
public class DingDepartment {
    @ApiModelProperty(value = "部门id",example = "部门id")
    private Integer id;

    @ApiModelProperty(value = "部门名称",example = "部门名称")
    private String name;

    @ApiModelProperty(value = "父部门id，根部门为1",example = "父部门id，根部门为1")
    private Integer parentid;

    @ApiModelProperty(value = "是否同步创建一个关联此部门的企业群，true表示是，false表示不是",example = "是否同步创建一个关联此部门的企业群，true表示是，false表示不是")
    private boolean createDeptGroup;

    @ApiModelProperty(value = "当群已经创建后，是否有新人加入部门会自动加入该群, true表示是，false表示不是",example = "当群已经创建后，是否有新人加入部门会自动加入该群, true表示是，false表示不是")
    private boolean autoAddUser;

    @ApiModelProperty(value = "部门自定义字段",example = "部门自定义字段")
    private String ext;
}
